/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.snmp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Optional;
import javax.persistence.Entity;
import org.openremote.agent.protocol.snmp.SNMPAgentLink;
import org.openremote.agent.protocol.snmp.SNMPProtocol;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueConstraint;
import org.openremote.model.value.ValueDescriptor;

@Entity
public class SNMPAgent
extends Agent<SNMPAgent, SNMPProtocol, SNMPAgentLink> {
    public static final ValueDescriptor<SNMPVersion> VALUE_SNMP_VERSION = new ValueDescriptor("SNMPVersion", SNMPVersion.class, new ValueConstraint[0]);
    public static final AttributeDescriptor<SNMPVersion> SNMP_VERSION = new AttributeDescriptor("SNMPVersionValue", VALUE_SNMP_VERSION);
    public static final AttributeDescriptor<String> SNMP_BIND_HOST = BIND_HOST.withOptional(false);
    public static final AttributeDescriptor<Integer> SNMP_BIND_PORT = BIND_PORT.withOptional(false);
    public static final AgentDescriptor<SNMPAgent, SNMPProtocol, SNMPAgentLink> DESCRIPTOR = new AgentDescriptor(SNMPAgent.class, SNMPProtocol.class, SNMPAgentLink.class);

    protected SNMPAgent() {
    }

    public SNMPAgent(String name) {
        super(name);
    }

    public SNMPProtocol getProtocolInstance() {
        return new SNMPProtocol(this);
    }

    public Optional<SNMPVersion> getSNMPVersion() {
        return this.getAttributes().getValue(SNMP_VERSION);
    }

    public SNMPAgent setSNMPVersion(SNMPVersion version) {
        this.getAttributes().getOrCreate(SNMP_VERSION).setValue((Object)version);
        return this;
    }

    public static enum SNMPVersion {
        V1(0),
        V2c(1),
        V3(3);

        private final int version;

        private SNMPVersion(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }

        @JsonValue
        public String getValue() {
            return this.toString();
        }
    }
}

