/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.simulator.storage;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.simulator.storage.StorageSimulatorAgent;
import org.openremote.agent.protocol.simulator.storage.StorageSimulatorAgentLink;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.impl.ElectricityStorageAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.syslog.SyslogCategory;

public class StorageSimulatorProtocol
extends AbstractProtocol<StorageSimulatorAgent, StorageSimulatorAgentLink> {
    public static final String PROTOCOL_DISPLAY_NAME = "StorageSimulator";
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, StorageSimulatorProtocol.class);
    protected final Map<String, Instant> lastUpdateMap = new HashMap<String, Instant>();
    protected final Map<String, ScheduledFuture<?>> simulationMap = new HashMap();
    protected final Map<String, ScheduledFuture<?>> initFutureMap = new HashMap();

    public StorageSimulatorProtocol(StorageSimulatorAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return "storagesimulator://" + ((StorageSimulatorAgent)this.agent).getId();
    }

    @Override
    protected void doStart(Container container) throws Exception {
        this.setConnectionStatus(ConnectionStatus.CONNECTED);
    }

    @Override
    protected void doStop(Container container) throws Exception {
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, StorageSimulatorAgentLink agentLink) throws RuntimeException {
        this.scheduleInit(assetId);
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, StorageSimulatorAgentLink agentLink) {
        this.scheduleInit(assetId);
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, StorageSimulatorAgentLink agentLink, AttributeEvent event, Object processedValue) {
        if (attribute.getName().equals(ElectricityStorageAsset.POWER.getName())) {
            return;
        }
        this.updateLinkedAttribute(new AttributeState(event.getAttributeRef(), processedValue));
        String assetId = event.getAssetId();
        attribute.setValue(processedValue);
        ElectricityStorageAsset asset = this.assetService.findAsset(assetId, ElectricityStorageAsset.class);
        asset.addOrReplaceAttributes(new Attribute[]{attribute});
        this.updateStorageAsset(asset);
    }

    protected void updateStorageAsset(ElectricityStorageAsset storageAsset) {
        Duration duration;
        long seconds;
        if (storageAsset == null) {
            LOG.finest("Storage asset not set so skipping update");
            return;
        }
        String assetId = storageAsset.getId();
        Instant previousTimestamp = this.lastUpdateMap.remove(assetId);
        ScheduledFuture<?> scheduledFuture = this.simulationMap.remove(assetId);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        boolean setpointLinked = this.getLinkedAttributes().containsKey(new AttributeRef(assetId, ElectricityStorageAsset.POWER_SETPOINT.getName()));
        boolean powerLinked = this.getLinkedAttributes().containsKey(new AttributeRef(assetId, ElectricityStorageAsset.POWER.getName()));
        boolean levelLinked = this.getLinkedAttributes().containsKey(new AttributeRef(assetId, ElectricityStorageAsset.ENERGY_LEVEL.getName()));
        if (!(setpointLinked && powerLinked && levelLinked)) {
            LOG.fine("Not all required attributes are linked or don't have values (setpoint, power and energy level): " + assetId);
            return;
        }
        Instant now = Instant.now();
        double setpoint = storageAsset.getPowerSetpoint().orElse(0.0);
        double capacity = storageAsset.getEnergyCapacity().orElse(0.0);
        double power = storageAsset.getPower().orElse(0.0);
        double level = storageAsset.getEnergyLevel().orElse(0.0);
        int minPercentage = storageAsset.getEnergyLevelPercentageMin().orElse(0);
        int maxPercentage = storageAsset.getEnergyLevelPercentageMax().orElse(100);
        capacity = Math.max(0.0, capacity);
        level = Math.max(0.0, Math.min(capacity, level));
        double maxLevel = (double)maxPercentage / 100.0 * capacity;
        double minLevel = (double)minPercentage / 100.0 * capacity;
        if (capacity <= 0.0) {
            LOG.info("Storage asset capacity is 0 so not usable: " + assetId);
            level = 0.0;
            setpoint = 0.0;
        }
        if (capacity > 0.0 && power != 0.0 && previousTimestamp != null && (seconds = (duration = Duration.between(previousTimestamp, now)).getSeconds()) > 0L) {
            double deltaHours = (double)seconds / 3600.0;
            double efficiency = power > 0.0 ? (double)storageAsset.getEfficiencyImport().orElse(100).intValue() / 100.0 : 1.0 / ((double)storageAsset.getEfficiencyExport().orElse(100).intValue() / 100.0);
            double energyDelta = power * deltaHours * efficiency;
            double newLevel = Math.max(0.0, Math.min(capacity, level + energyDelta));
            energyDelta = newLevel - level;
            level = newLevel;
            if (energyDelta > 0.0) {
                this.updateLinkedAttribute(new AttributeState(storageAsset.getId(), ElectricityStorageAsset.ENERGY_IMPORT_TOTAL.getName(), (Object)(storageAsset.getEnergyImportTotal().orElse(0.0) + energyDelta)));
            } else {
                this.updateLinkedAttribute(new AttributeState(storageAsset.getId(), ElectricityStorageAsset.ENERGY_EXPORT_TOTAL.getName(), (Object)(storageAsset.getEnergyExportTotal().orElse(0.0) - energyDelta)));
            }
        }
        double d = power = setpoint < 0.0 && level <= minLevel || setpoint > 0.0 && level >= maxLevel ? 0.0 : setpoint;
        if (power > 0.0 && !storageAsset.isSupportsImport().orElse(false).booleanValue()) {
            LOG.fine("Setpoint is requesting power import but asset does not support it: " + storageAsset);
            power = 0.0;
        } else if (power < 0.0 && !storageAsset.isSupportsExport().orElse(false).booleanValue()) {
            LOG.fine("Setpoint is requesting power export but asset does not support it: " + storageAsset);
            power = 0.0;
        }
        this.updateLinkedAttribute(new AttributeState(assetId, ElectricityStorageAsset.POWER.getName(), (Object)power));
        this.updateLinkedAttribute(new AttributeState(assetId, ElectricityStorageAsset.ENERGY_LEVEL.getName(), (Object)level));
        this.updateLinkedAttribute(new AttributeState(assetId, ElectricityStorageAsset.ENERGY_LEVEL_PERCENTAGE.getName(), (Object)(capacity <= 0.0 ? 0 : (int)(level / capacity * 100.0))));
        if (power != 0.0) {
            this.lastUpdateMap.put(assetId, now);
            this.simulationMap.put(assetId, this.scheduleUpdate(assetId));
        }
    }

    protected void scheduleInit(String assetId) {
        ScheduledFuture<?> initFuture = this.initFutureMap.remove(assetId);
        if (initFuture != null) {
            initFuture.cancel(false);
        }
        this.initFutureMap.put(assetId, this.executorService.schedule(() -> {
            this.updateStorageAsset(this.assetService.findAsset(assetId, ElectricityStorageAsset.class));
            this.initFutureMap.remove(assetId);
        }, 1L, TimeUnit.SECONDS));
    }

    protected ScheduledFuture<?> scheduleUpdate(String assetId) {
        return this.executorService.schedule(() -> {
            try {
                this.updateStorageAsset(this.assetService.findAsset(assetId, ElectricityStorageAsset.class));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception in " + this.getProtocolName(), e);
                this.setConnectionStatus(ConnectionStatus.ERROR);
            }
        }, 1L, TimeUnit.MINUTES);
    }
}

