/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.simulator;

import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.simulator.SimulatorAgent;
import org.openremote.agent.protocol.simulator.SimulatorAgentLink;
import org.openremote.container.concurrent.GlobalLock;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.simulator.SimulatorReplayDatapoint;
import org.openremote.model.syslog.SyslogCategory;

public class SimulatorProtocol
extends AbstractProtocol<SimulatorAgent, SimulatorAgentLink> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, SimulatorProtocol.class);
    public static final String PROTOCOL_DISPLAY_NAME = "Simulator";
    protected final Map<AttributeRef, ScheduledFuture<?>> replayMap = new HashMap();

    public SimulatorProtocol(SimulatorAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return "simulator://" + ((SimulatorAgent)this.agent).getId();
    }

    @Override
    protected void doStart(Container container) throws Exception {
        this.setConnectionStatus(ConnectionStatus.CONNECTED);
    }

    @Override
    protected void doStop(Container container) throws Exception {
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, SimulatorAgentLink agentLink) {
        agentLink.getReplayData().ifPresent(simulatorReplayDatapoints -> {
            LOG.info("Simulator replay data found for linked attribute: " + attribute);
            AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
            ScheduledFuture<?> updateValueFuture = this.scheduleReplay(attributeRef, (SimulatorReplayDatapoint[])simulatorReplayDatapoints);
            if (updateValueFuture != null) {
                this.replayMap.put(attributeRef, updateValueFuture);
            } else {
                LOG.warning("Failed to schedule replay update value for simulator replay attribute: " + attribute);
                this.replayMap.put(attributeRef, null);
            }
        });
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, SimulatorAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        ScheduledFuture<?> updateValueFuture = this.replayMap.remove(attributeRef);
        if (updateValueFuture != null) {
            updateValueFuture.cancel(true);
        }
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, SimulatorAgentLink agentLink, AttributeEvent event, Object processedValue) {
        if (this.replayMap.containsKey(event.getAttributeRef())) {
            LOG.info("Attempt to write to linked attribute that is configured for value replay so ignoring: " + attribute);
            return;
        }
        LOG.finer("Write to linked attribute so simulating that the endpoint returned the written value");
        this.updateSensor(event.getAttributeRef(), processedValue);
    }

    public void updateSensor(AttributeEvent attributeEvent) {
        this.updateSensor(attributeEvent.getAttributeRef(), attributeEvent.getValue().orElse(null), attributeEvent.getTimestamp());
    }

    public void updateSensor(AttributeRef attributeRef, Object value) {
        this.updateSensor(attributeRef, value, this.timerService.getCurrentTimeMillis());
    }

    public void updateSensor(AttributeRef attributeRef, Object value, long timestamp) {
        Attribute<?> attribute = this.getLinkedAttributes().get(attributeRef);
        AttributeState state = new AttributeState(attributeRef, value);
        if (attribute == null) {
            LOG.info("Attempt to update unlinked attribute: " + state);
            return;
        }
        this.updateLinkedAttribute(state, timestamp);
    }

    public Map<AttributeRef, ScheduledFuture<?>> getReplayMap() {
        return this.replayMap;
    }

    protected ScheduledFuture<?> scheduleReplay(AttributeRef attributeRef, SimulatorReplayDatapoint[] simulatorReplayDatapoints) {
        LOG.finer("Scheduling linked attribute replay update");
        long now = LocalDateTime.now().get(ChronoField.SECOND_OF_DAY);
        SimulatorReplayDatapoint nextDatapoint = Arrays.stream(simulatorReplayDatapoints).filter(replaySimulatorDatapoint -> replaySimulatorDatapoint.timestamp > now).findFirst().orElse(simulatorReplayDatapoints[0]);
        if (nextDatapoint == null) {
            LOG.info("Next datapoint not found so replay cancelled: " + attributeRef);
            return null;
        }
        long nextRun = nextDatapoint.timestamp;
        if (nextRun <= now) {
            nextRun += 86400L;
        }
        long nextRunRelative = nextRun - now;
        LOG.info("Next update for asset " + attributeRef.getId() + " for attribute " + attributeRef.getName() + " in " + nextRunRelative + " second(s)");
        return this.executorService.schedule(() -> GlobalLock.withLock((String)(this.getProtocolName() + "::firingNextUpdate"), () -> {
            LOG.info("Updating asset " + attributeRef.getId() + " for attribute " + attributeRef.getName() + " with value " + nextDatapoint.value.toString());
            try {
                this.updateLinkedAttribute(new AttributeState(attributeRef, nextDatapoint.value));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception thrown when updating value: %s", e);
            }
            finally {
                this.replayMap.put(attributeRef, this.scheduleReplay(attributeRef, simulatorReplayDatapoints));
            }
        }), nextRunRelative, TimeUnit.SECONDS);
    }
}

