/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.serial;

import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.io.IOAgent;
import org.openremote.agent.protocol.serial.AbstractSerialProtocol;
import org.openremote.agent.protocol.serial.SerialAgent;
import org.openremote.agent.protocol.serial.SerialIOClient;
import org.openremote.container.timer.TimerService;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.DefaultAgentLink;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeExecuteStatus;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.protocol.ProtocolUtil;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class SerialProtocol
extends AbstractSerialProtocol<SerialProtocol, SerialAgent, DefaultAgentLink, String, SerialIOClient<String>> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, SerialProtocol.class);
    public static final String PROTOCOL_DISPLAY_NAME = "Serial";
    protected final List<Pair<AttributeRef, Consumer<String>>> protocolMessageConsumers = new ArrayList<Pair<AttributeRef, Consumer<String>>>();

    public SerialProtocol(SerialAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, DefaultAgentLink agentLink) {
        Consumer messageConsumer = ProtocolUtil.createGenericAttributeMessageConsumer((String)assetId, attribute, (AgentLink)agentLink, () -> ((TimerService)this.timerService).getCurrentTimeMillis(), x$0 -> this.updateLinkedAttribute((AttributeState)x$0));
        if (messageConsumer != null) {
            this.protocolMessageConsumers.add((Pair<AttributeRef, Consumer<String>>)new Pair((Object)new AttributeRef(assetId, attribute.getName()), (Object)messageConsumer));
        }
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, DefaultAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        this.protocolMessageConsumers.removeIf(attRefConsumerPair -> ((AttributeRef)attRefConsumerPair.key).equals((Object)attributeRef));
    }

    @Override
    protected Supplier<ChannelHandler[]> getEncoderDecoderProvider() {
        return SerialProtocol.getGenericStringEncodersAndDecoders((AbstractNettyIOClient)this.client, (IOAgent)this.agent);
    }

    @Override
    protected void onMessageReceived(String message) {
        this.protocolMessageConsumers.forEach(c -> {
            if (c.value != null) {
                ((Consumer)c.value).accept(message);
            }
        });
    }

    @Override
    protected String createWriteMessage(Attribute<?> attribute, DefaultAgentLink agentLink, AttributeEvent event, Object processedValue) {
        AttributeExecuteStatus status;
        if (attribute.getType().equals((Object)ValueType.EXECUTION_STATUS) && (status = (AttributeExecuteStatus)event.getValue().flatMap(ValueUtil::getString).flatMap(AttributeExecuteStatus::fromString).orElse(null)) != null && status != AttributeExecuteStatus.REQUEST_START) {
            LOG.fine("Unsupported execution status: " + status);
            return null;
        }
        return (String)ValueUtil.convert((Object)processedValue, String.class);
    }
}

