/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.serial;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.net.SocketAddress;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.serial.JSerialCommChannel;
import org.openremote.agent.protocol.serial.JSerialCommChannelConfig;
import org.openremote.agent.protocol.serial.JSerialCommChannelOption;
import org.openremote.agent.protocol.serial.JSerialCommDeviceAddress;
import org.openremote.model.util.TextUtil;

public class SerialIOClient<T>
extends AbstractNettyIOClient<T, JSerialCommDeviceAddress> {
    protected String port;
    protected int baudRate;
    public static int DEFAULT_BAUD_RATE = 38400;

    public SerialIOClient(String port, Integer baudRate) {
        TextUtil.requireNonNullAndNonEmpty((String)port);
        this.port = port;
        this.baudRate = baudRate == null ? DEFAULT_BAUD_RATE : baudRate;
    }

    @Override
    protected Class<? extends Channel> getChannelClass() {
        return JSerialCommChannel.class;
    }

    @Override
    protected ChannelFuture startChannel() {
        return this.bootstrap.connect((SocketAddress)new JSerialCommDeviceAddress(this.port));
    }

    @Override
    public String getClientUri() {
        return "serial://" + this.port;
    }

    @Override
    protected EventLoopGroup getWorkerGroup() {
        return new OioEventLoopGroup(1);
    }

    @Override
    protected void configureChannel() {
        super.configureChannel();
        this.bootstrap.option(JSerialCommChannelOption.BAUD_RATE, (Object)this.baudRate);
        this.bootstrap.option(JSerialCommChannelOption.DATA_BITS, (Object)8);
        this.bootstrap.option(JSerialCommChannelOption.STOP_BITS, (Object)JSerialCommChannelConfig.Stopbits.STOPBITS_1);
        this.bootstrap.option(JSerialCommChannelOption.PARITY_BIT, (Object)JSerialCommChannelConfig.Paritybit.NONE);
    }
}

