/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.mqtt;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.openremote.agent.protocol.mqtt.AbstractMQTTClientProtocol;
import org.openremote.agent.protocol.mqtt.MQTTAgent;
import org.openremote.agent.protocol.mqtt.MQTTAgentLink;
import org.openremote.agent.protocol.mqtt.MQTTMessage;
import org.openremote.agent.protocol.mqtt.MQTT_IOClient;
import org.openremote.container.util.UniqueIdentifierGenerator;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.ValueUtil;

public class MQTTProtocol
extends AbstractMQTTClientProtocol<MQTTProtocol, MQTTAgent, String, MQTT_IOClient, MQTTAgentLink> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, MQTTProtocol.class);
    public static final String PROTOCOL_DISPLAY_NAME = "MQTT Client";
    protected final Map<AttributeRef, Consumer<MQTTMessage<String>>> protocolMessageConsumers = new HashMap<AttributeRef, Consumer<MQTTMessage<String>>>();

    protected MQTTProtocol(MQTTAgent agent) {
        super(agent);
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, MQTTAgentLink agentLink) throws RuntimeException {
        agentLink.getSubscriptionTopic().ifPresent(topic -> {
            Consumer messageConsumer = msg -> this.updateLinkedAttribute(new AttributeState(assetId, attribute.getName(), msg.payload));
            ((MQTT_IOClient)this.client).addMessageConsumer((String)topic, messageConsumer);
            this.protocolMessageConsumers.put(new AttributeRef(assetId, attribute.getName()), messageConsumer);
        });
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, MQTTAgentLink agentLink) {
        agentLink.getSubscriptionTopic().ifPresent(topic -> {
            AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
            Consumer messageConsumer = this.protocolMessageConsumers.remove(attributeRef);
            if (messageConsumer != null) {
                ((MQTT_IOClient)this.client).removeMessageConsumer((String)topic, messageConsumer);
            }
        });
    }

    @Override
    protected MQTT_IOClient createIoClient() throws Exception {
        MQTT_IOClient client = (MQTT_IOClient)super.createIoClient();
        client.removeAllMessageConsumers();
        return client;
    }

    @Override
    protected MQTT_IOClient doCreateIoClient() throws Exception {
        String host = ((MQTTAgent)this.agent).getHost().orElse(null);
        int port = ((MQTTAgent)this.agent).getPort().orElseGet(() -> {
            if (((MQTTAgent)this.agent).isSecureMode().orElse(false).booleanValue()) {
                return ((MQTTAgent)this.agent).isWebsocketMode().orElse(false) != false ? 443 : 8883;
            }
            return ((MQTTAgent)this.agent).isWebsocketMode().orElse(false) != false ? 80 : 1883;
        });
        URI websocketURI = null;
        if (((MQTTAgent)this.agent).isWebsocketMode().orElse(false).booleanValue()) {
            URIBuilder builder = new URIBuilder().setHost(host).setPort(port);
            ((MQTTAgent)this.agent).getWebsocketPath().ifPresent(arg_0 -> ((URIBuilder)builder).setPath(arg_0));
            ((MQTTAgent)this.agent).getWebsocketQuery().map(query -> query.startsWith("?") ? query.substring(1) : query).ifPresent(arg_0 -> ((URIBuilder)builder).setCustomQuery(arg_0));
            websocketURI = builder.build();
        }
        return new MQTT_IOClient(((MQTTAgent)this.agent).getClientId().orElseGet(UniqueIdentifierGenerator::generateId), host, port, ((MQTTAgent)this.agent).isSecureMode().orElse(false), ((MQTTAgent)this.agent).isResumeSession().orElse(false) == false, ((MQTTAgent)this.agent).getUsernamePassword().orElse(null), websocketURI);
    }

    @Override
    protected void onMessageReceived(MQTTMessage<String> message) {
    }

    @Override
    protected MQTTMessage<String> createWriteMessage(Attribute<?> attribute, MQTTAgentLink agentLink, AttributeEvent event, Object processedValue) {
        Optional<String> topic = agentLink.getPublishTopic();
        if (!topic.isPresent()) {
            LOG.fine(this.prefixLogMessage("Publish topic is not set in agent link so cannot publish message"));
            return null;
        }
        String valueStr = (String)ValueUtil.convert((Object)processedValue, String.class);
        return new MQTTMessage<String>(topic.get(), valueStr);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }
}

