/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.mqtt;

import java.util.Optional;
import javax.persistence.Entity;
import org.openremote.agent.protocol.io.IOAgent;
import org.openremote.agent.protocol.mqtt.MQTTAgentLink;
import org.openremote.agent.protocol.mqtt.MQTTProtocol;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueType;

@Entity
public class MQTTAgent
extends IOAgent<MQTTAgent, MQTTProtocol, MQTTAgentLink> {
    public static final AttributeDescriptor<String> MQTT_HOST = HOST.withOptional(false);
    public static final AttributeDescriptor<Integer> MQTT_PORT = PORT.withOptional(false);
    public static final AttributeDescriptor<String> CLIENT_ID = new AttributeDescriptor("clientId", ValueType.TEXT);
    public static final AttributeDescriptor<Boolean> SECURE_MODE = new AttributeDescriptor("secureMode", ValueType.BOOLEAN);
    public static final AttributeDescriptor<Boolean> RESUME_SESSION = new AttributeDescriptor("resumeSession", ValueType.BOOLEAN);
    public static final AttributeDescriptor<Boolean> WEBSOCKET_MODE = new AttributeDescriptor("websocketMode", ValueType.BOOLEAN);
    public static final AttributeDescriptor<String> WEBSOCKET_PATH = new AttributeDescriptor("websocketPath", ValueType.TEXT);
    public static final AttributeDescriptor<String> WEBSOCKET_QUERY = new AttributeDescriptor("websocketQuery", ValueType.TEXT);
    public static final AgentDescriptor<MQTTAgent, MQTTProtocol, MQTTAgentLink> DESCRIPTOR = new AgentDescriptor(MQTTAgent.class, MQTTProtocol.class, MQTTAgentLink.class);

    protected MQTTAgent() {
    }

    public MQTTAgent(String name) {
        super(name);
    }

    public MQTTProtocol getProtocolInstance() {
        return new MQTTProtocol(this);
    }

    public Optional<String> getClientId() {
        return this.getAttributes().getValue(CLIENT_ID);
    }

    public MQTTAgent setClientId(String clientId) {
        this.getAttributes().getOrCreate(CLIENT_ID).setValue((Object)clientId);
        return this;
    }

    public Optional<Boolean> isSecureMode() {
        return this.getAttributes().getValue(SECURE_MODE);
    }

    public MQTTAgent setSecureMode(boolean secureMode) {
        this.getAttributes().getOrCreate(SECURE_MODE).setValue((Object)secureMode);
        return this;
    }

    public Optional<Boolean> isWebsocketMode() {
        return this.getAttributes().getValue(WEBSOCKET_MODE);
    }

    public MQTTAgent setWebsocketMode(boolean websocketMode) {
        this.getAttributes().getOrCreate(WEBSOCKET_MODE).setValue((Object)websocketMode);
        return this;
    }

    public Optional<Boolean> isResumeSession() {
        return this.getAttributes().getValue(RESUME_SESSION);
    }

    public MQTTAgent setResumeSession(boolean resumeSession) {
        this.getAttributes().getOrCreate(RESUME_SESSION).setValue((Object)resumeSession);
        return this;
    }

    public Optional<String> getWebsocketPath() {
        return this.getAttributes().getValue(WEBSOCKET_PATH);
    }

    public MQTTAgent setWebsocketPath(String websocketPath) {
        this.getAttributes().getOrCreate(WEBSOCKET_PATH).setValue((Object)websocketPath);
        return this;
    }

    public Optional<String> getWebsocketQuery() {
        return this.getAttributes().getValue(WEBSOCKET_QUERY);
    }

    public MQTTAgent setWebsocketQuery(String websocketQuery) {
        this.getAttributes().getOrCreate(WEBSOCKET_QUERY).setValue((Object)websocketQuery);
        return this;
    }
}

