/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.knx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.IOUtils;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.knx.ETSFileURIResolver;
import org.openremote.agent.protocol.knx.KNXAgent;
import org.openremote.agent.protocol.knx.KNXAgentLink;
import org.openremote.agent.protocol.knx.KNXConnection;
import org.openremote.agent.protocol.knx.TypeMapper;
import org.openremote.model.Container;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetTreeNode;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.impl.ThingAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.protocol.ProtocolAssetImport;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.value.AbstractNameValueHolder;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.ValueDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.datapoint.CommandDP;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlReader;

public class KNXProtocol
extends AbstractProtocol<KNXAgent, KNXAgentLink>
implements ProtocolAssetImport {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, KNXProtocol.class);
    public static final String PROTOCOL_DISPLAY_NAME = "KNX";
    protected KNXConnection connection;
    protected final Map<AttributeRef, Datapoint> attributeActionMap = new HashMap<AttributeRef, Datapoint>();
    protected final Map<AttributeRef, StateDP> attributeStatusMap = new HashMap<AttributeRef, StateDP>();

    public KNXProtocol(KNXAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    @Override
    protected void doStart(Container container) throws Exception {
        boolean isNat = ((KNXAgent)this.agent).isNATMode().orElse(false);
        boolean isRouting = ((KNXAgent)this.agent).isRoutingMode().orElse(false);
        String gatewayAddress = (String)((KNXAgent)this.agent).getHost().orElseThrow(() -> {
            String msg = "No KNX gateway IP address provided for protocol: " + this;
            LOG.info(msg);
            return new IllegalArgumentException(msg);
        });
        String bindAddress = ((KNXAgent)this.agent).getBindHost().orElse(null);
        Integer gatewayPort = ((KNXAgent)this.agent).getPort().orElse(3671);
        String messageSourceAddress = ((KNXAgent)this.agent).getMessageSourceAddress().orElse("0.0.0");
        this.connection = new KNXConnection(gatewayAddress, bindAddress, gatewayPort, messageSourceAddress, isRouting, isNat);
        this.connection.addConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
        this.connection.connect();
    }

    @Override
    protected void doStop(Container container) throws Exception {
        if (this.connection != null) {
            this.connection.removeConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
            this.connection.disconnect();
        }
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, KNXAgentLink agentLink) throws RuntimeException {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        String dpt = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDpt(), (String)"DPT");
        Optional<String> statusGA = agentLink.getStatusGroupAddress();
        Optional<String> actionGA = agentLink.getActionGroupAddress();
        if (!statusGA.isPresent() && !actionGA.isPresent()) {
            LOG.warning("No status group address or action group address provided so nothing to do for protocol attribute: " + attributeRef);
            return;
        }
        statusGA.ifPresent(groupAddress -> {
            try {
                this.addStatusDatapoint(attributeRef, (String)groupAddress, dpt);
            }
            catch (KNXFormatException e) {
                LOG.severe("Give action group address is invalid for protocol attribute: " + attributeRef + " - " + e.getMessage());
            }
        });
        actionGA.ifPresent(groupAddress -> {
            try {
                this.addActionDatapoint(attributeRef, (String)groupAddress, dpt);
            }
            catch (KNXFormatException e) {
                LOG.severe("Give action group address is invalid for protocol attribute: " + attributeRef + " - " + e.getMessage());
            }
        });
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, KNXAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        this.removeStatusDatapoint(attributeRef);
        this.removeActionDatapoint(attributeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, KNXAgentLink agentLink, AttributeEvent event, Object processedValue) {
        Map<AttributeRef, Datapoint> map = this.attributeActionMap;
        synchronized (map) {
            Datapoint datapoint = this.attributeActionMap.get(event.getAttributeRef());
            if (datapoint == null) {
                LOG.fine("Attribute isn't linked to a KNX datapoint so cannot process write: " + event);
                return;
            }
            this.connection.sendCommand(datapoint, event.getValue());
            this.updateLinkedAttribute(event.getAttributeState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addActionDatapoint(AttributeRef attributeRef, String groupAddress, String dpt) throws KNXFormatException {
        Map<AttributeRef, Datapoint> map = this.attributeActionMap;
        synchronized (map) {
            CommandDP datapoint = new CommandDP(new GroupAddress(groupAddress), attributeRef.getName());
            datapoint.setDPT(0, dpt);
            this.attributeActionMap.put(attributeRef, (Datapoint)datapoint);
            LOG.info("Attribute registered for sending commands: " + attributeRef + " with datapoint: " + (Datapoint)datapoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActionDatapoint(AttributeRef attributeRef) {
        Map<AttributeRef, Datapoint> map = this.attributeActionMap;
        synchronized (map) {
            this.attributeActionMap.remove(attributeRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStatusDatapoint(AttributeRef attributeRef, String groupAddress, String dpt) throws KNXFormatException {
        Map<AttributeRef, StateDP> map = this.attributeStatusMap;
        synchronized (map) {
            StateDP datapoint = new StateDP(new GroupAddress(groupAddress), attributeRef.getName(), 0, dpt);
            this.connection.addDatapointValueConsumer(datapoint, value -> this.handleKNXValueChange(attributeRef, value));
            this.attributeStatusMap.put(attributeRef, datapoint);
            LOG.info("Attribute registered for status updates: " + attributeRef + " with datapoint: " + datapoint);
        }
    }

    protected void handleKNXValueChange(AttributeRef attributeRef, Object value) {
        LOG.fine("KNX protocol received value '" + value + "' for : " + attributeRef);
        this.updateLinkedAttribute(new AttributeState(attributeRef, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStatusDatapoint(AttributeRef attributeRef) {
        Map<AttributeRef, StateDP> map = this.attributeStatusMap;
        synchronized (map) {
            StateDP statusDP = this.attributeStatusMap.remove(attributeRef);
            if (statusDP != null) {
                this.connection.removeDatapointValueConsumer(statusDP);
            }
        }
    }

    public String getProtocolInstanceUri() {
        return "knx://" + this.connection;
    }

    public Future<Void> startAssetImport(byte[] fileData, Consumer<AssetTreeNode[]> assetConsumer) {
        return this.executorService.submit(() -> {
            ZipInputStream zin = null;
            try {
                boolean fileFound = false;
                zin = new ZipInputStream(new ByteArrayInputStream(fileData));
                ZipEntry zipEntry = zin.getNextEntry();
                while (zipEntry != null) {
                    if (zipEntry.getName().endsWith("/0.xml")) {
                        fileFound = true;
                        break;
                    }
                    zipEntry = zin.getNextEntry();
                }
                if (!fileFound) {
                    String msg = "Failed to find '0.xml' in project file";
                    LOG.info(msg);
                    throw new IllegalStateException(msg);
                }
                TransformerFactoryImpl tfactory = new TransformerFactoryImpl();
                InputStream inputStream = KNXProtocol.class.getResourceAsStream("/org/openremote/agent/protocol/knx/ets_calimero_group_name.xsl");
                String xsd = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                xsd = xsd.trim().replaceFirst("^([\\W]+)<", "<");
                LOG.warning(xsd);
                Transformer transformer = tfactory.newTransformer(new StreamSource(new StringReader(xsd)));
                transformer.setURIResolver(new ETSFileURIResolver(fileData));
                String xml = IOUtils.toString((InputStream)zin, (Charset)StandardCharsets.UTF_8);
                xml = xml.trim().replaceFirst("^([\\W]+)<", "<");
                LOG.warning(xml);
                StringWriter writer = new StringWriter();
                StringReader reader = new StringReader(xml);
                transformer.transform(new StreamSource(reader), new StreamResult(writer));
                xml = writer.toString();
                DatapointMap datapoints = new DatapointMap();
                try (XmlReader r = XmlInputFactory.newInstance().createXMLStreamReader((Reader)new StringReader(xml));){
                    datapoints.load(r);
                }
                catch (KNXMLException e) {
                    String msg = "Error loading parsed ETS file: " + e.getMessage();
                    LOG.warning(msg);
                    throw new IllegalStateException(msg, e);
                }
                HashMap createdAssets = new HashMap();
                for (StateDP dp : datapoints.getDatapoints()) {
                    if (dp.getName().endsWith("#A")) {
                        this.createAsset(dp, false, createdAssets);
                        continue;
                    }
                    if (dp.getName().endsWith("#S")) {
                        this.createAsset(dp, true, createdAssets);
                        continue;
                    }
                    if (dp.getName().endsWith("#SA") || dp.getName().endsWith("#AS")) {
                        this.createAsset(dp, false, createdAssets);
                        this.createAsset(dp, true, createdAssets);
                        continue;
                    }
                    LOG.info("Only group addresses ending on #A, #S, #AS or #SA will be imported. Ignoring: " + dp.getName());
                }
                assetConsumer.accept((AssetTreeNode[])createdAssets.values().stream().map(AssetTreeNode::new).toArray(AssetTreeNode[]::new));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "ETS import error", e);
            }
            finally {
                if (zin != null) {
                    try {
                        zin.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, null);
    }

    protected void createAsset(StateDP datapoint, boolean isStatusGA, Map<String, Asset<?>> createdAssets) {
        String name = datapoint.getName().substring(0, datapoint.getName().length() - 3);
        String assetName = name.replaceAll(" -.*-", "");
        ThingAsset asset = createdAssets.containsKey(assetName) ? createdAssets.get(assetName) : new ThingAsset(assetName);
        String attrName = assetName.replaceAll(" ", "");
        ValueDescriptor<?> type = TypeMapper.toAttributeType((Datapoint)datapoint);
        KNXAgentLink agentLink = new KNXAgentLink(((KNXAgent)this.agent).getId(), datapoint.getDPT(), !isStatusGA ? datapoint.getMainAddress().toString() : null, isStatusGA ? datapoint.getMainAddress().toString() : null);
        Attribute attr = asset.getAttributes().get(attrName).orElse(new Attribute(attrName, type).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)name), new MetaItem(MetaItemType.AGENT_LINK, (Object)agentLink)}));
        asset.getAttributes().addOrReplace((AbstractNameValueHolder)attr);
        createdAssets.put(assetName, (Asset<?>)asset);
    }
}

