/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.knx;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.openremote.agent.protocol.knx.TypeMapper;
import org.openremote.container.Container;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.KNXNetworkLinkIP;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessCommunicatorImpl;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.process.ProcessListener;

public class KNXConnection
implements NetworkLinkListener,
ProcessListener {
    protected ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
    protected static final int INITIAL_RECONNECT_DELAY_MILLIS = 1000;
    protected static final int MAX_RECONNECT_DELAY_MILLIS = 60000;
    protected static final int RECONNECT_BACKOFF_MULTIPLIER = 2;
    protected ScheduledFuture<?> reconnectTask;
    protected int reconnectDelayMilliseconds = 1000;
    protected final List<Consumer<ConnectionStatus>> connectionStatusConsumers = new ArrayList<Consumer<ConnectionStatus>>();
    protected final ScheduledExecutorService executorService;
    protected final String gatewayAddress;
    private final int gatewayPort;
    private final boolean natMode;
    private final String messageSourceAddress;
    private final String bindAddress;
    protected final int port = 3671;
    protected final boolean routingMode;
    protected KNXNetworkLink knxLink;
    protected ProcessCommunicator processCommunicator;
    protected final Map<GroupAddress, byte[]> groupAddressStateMap = new HashMap<GroupAddress, byte[]>();
    protected final Map<GroupAddress, List<Pair<StateDP, Consumer<Object>>>> groupAddressConsumerMap = new HashMap<GroupAddress, List<Pair<StateDP, Consumer<Object>>>>();
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, KNXConnection.class);

    public KNXConnection(String gatewayAddress, String bindAddress, Integer gatewayPort, String messageSourceAddress, boolean routingMode, boolean natMode) {
        this.gatewayAddress = gatewayAddress;
        this.executorService = Container.EXECUTOR_SERVICE;
        this.routingMode = routingMode;
        this.bindAddress = bindAddress;
        this.gatewayPort = gatewayPort;
        this.natMode = natMode;
        this.messageSourceAddress = messageSourceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() {
        block10: {
            if (this.connectionStatus == ConnectionStatus.CONNECTED || this.connectionStatus == ConnectionStatus.CONNECTING) {
                LOG.finest("Already connected or connection in progress");
                return;
            }
            this.onConnectionStatusChanged(ConnectionStatus.CONNECTING);
            InetSocketAddress remoteEndPoint = new InetSocketAddress(this.gatewayAddress, this.gatewayPort);
            try {
                InetSocketAddress localEndPoint;
                TPSettings tpSettings = new TPSettings(new IndividualAddress(this.messageSourceAddress));
                if (StringUtils.isNotBlank((CharSequence)this.bindAddress)) {
                    localEndPoint = new InetSocketAddress(this.bindAddress, 0);
                } else {
                    InetAddress localHost = InetAddress.getLocalHost();
                    localEndPoint = new InetSocketAddress(localHost, 0);
                }
                this.knxLink = !this.routingMode ? KNXNetworkLinkIP.newTunnelingLink((InetSocketAddress)localEndPoint, (InetSocketAddress)remoteEndPoint, (boolean)this.natMode, (KNXMediumSettings)tpSettings) : KNXNetworkLinkIP.newRoutingLink((InetAddress)localEndPoint.getAddress(), (InetAddress)remoteEndPoint.getAddress(), (KNXMediumSettings)tpSettings);
                if (this.knxLink.isOpen()) {
                    LOG.fine("Successfully connected to: " + this.gatewayAddress + ":3671");
                    this.processCommunicator = new ProcessCommunicatorImpl(this.knxLink);
                    this.processCommunicator.addProcessListener((ProcessListener)this);
                    this.knxLink.addLinkListener((NetworkLinkListener)this);
                    this.reconnectTask = null;
                    this.reconnectDelayMilliseconds = 1000;
                    this.onConnectionStatusChanged(ConnectionStatus.CONNECTED);
                    LOG.finer("Initialising group address values");
                    Map<GroupAddress, List<Pair<StateDP, Consumer<Object>>>> map = this.groupAddressConsumerMap;
                    synchronized (map) {
                        this.groupAddressConsumerMap.forEach((groupAddress, datapointConsumerList) -> {
                            if (!datapointConsumerList.isEmpty()) {
                                Pair datapointConsumer = (Pair)datapointConsumerList.get(0);
                                this.getGroupAddressValue(((StateDP)datapointConsumer.key).getMainAddress(), ((StateDP)datapointConsumer.key).getPriority());
                            }
                        });
                        break block10;
                    }
                }
                LOG.log(Level.INFO, "Connection error");
                this.scheduleReconnect();
            }
            catch (InterruptedException | KNXException e) {
                LOG.log(Level.INFO, "Connection error", e.getMessage());
                this.scheduleReconnect();
            }
            catch (UnknownHostException e) {
                LOG.log(Level.INFO, "Connection error", e.getMessage());
            }
        }
    }

    public synchronized void disconnect() {
        if (this.connectionStatus == ConnectionStatus.DISCONNECTING || this.connectionStatus == ConnectionStatus.DISCONNECTED) {
            LOG.finest("Already disconnecting or disconnected");
            return;
        }
        LOG.finest("Disconnecting");
        this.onConnectionStatusChanged(ConnectionStatus.DISCONNECTING);
        if (this.processCommunicator != null) {
            this.processCommunicator.detach();
        }
        if (this.knxLink != null) {
            this.knxLink.removeLinkListener((NetworkLinkListener)this);
            this.knxLink.close();
            this.knxLink = null;
        }
        this.onConnectionStatusChanged(ConnectionStatus.DISCONNECTED);
    }

    public synchronized void addConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        if (!this.connectionStatusConsumers.contains(connectionStatusConsumer)) {
            this.connectionStatusConsumers.add(connectionStatusConsumer);
        }
    }

    public synchronized void removeConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        this.connectionStatusConsumers.remove(connectionStatusConsumer);
    }

    protected synchronized void onConnectionStatusChanged(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
        this.connectionStatusConsumers.forEach(consumer -> consumer.accept(connectionStatus));
    }

    public void sendCommand(Datapoint datapoint, Optional<Object> value) {
        try {
            if (this.connectionStatus == ConnectionStatus.CONNECTED && value.isPresent()) {
                LOG.finer("Sending to KNX action datapoint '" + datapoint + "': " + value);
                Object val = value.get();
                DPTXlator translator = TypeMapper.toDPTXlator(datapoint, val);
                this.processCommunicator.write(datapoint.getMainAddress(), translator);
            }
        }
        catch (KNXAckTimeoutException e) {
            LOG.log(Level.INFO, "Failed to send KNX value: " + datapoint + " : " + value, e);
            this.onConnectionError();
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
        }
    }

    public void groupWrite(ProcessEvent e) {
        this.onGroupAddressUpdated(e.getDestination(), e.getASDU());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onGroupAddressUpdated(GroupAddress groupAddress, byte[] value) {
        Map<GroupAddress, Object> map = this.groupAddressStateMap;
        synchronized (map) {
            this.groupAddressStateMap.compute(groupAddress, (ga, oldValue) -> value);
        }
        map = this.groupAddressConsumerMap;
        synchronized (map) {
            this.groupAddressConsumerMap.computeIfPresent(groupAddress, (ga, datapointAndConsumerList) -> {
                datapointAndConsumerList.forEach(datapointAndConsumer -> {
                    StateDP datapoint = (StateDP)datapointAndConsumer.key;
                    Consumer consumer = (Consumer)datapointAndConsumer.value;
                    this.updateConsumer(value, datapoint, consumer);
                });
                return datapointAndConsumerList;
            });
        }
    }

    public void groupReadRequest(ProcessEvent e) {
    }

    public void groupReadResponse(ProcessEvent e) {
        this.groupWrite(e);
    }

    public void detached(DetachEvent e) {
        LOG.log(Level.INFO, "KNX link detached", e.getSource());
    }

    public void indication(FrameEvent e) {
    }

    public void linkClosed(CloseEvent e) {
        LOG.log(Level.INFO, "KNX link closed", e.getReason());
        this.onConnectionError();
    }

    public void confirmation(FrameEvent e) {
    }

    protected void onConnectionError() {
        this.onConnectionStatusChanged(ConnectionStatus.ERROR);
        this.processCommunicator.detach();
        if (this.knxLink != null) {
            this.knxLink.removeLinkListener((NetworkLinkListener)this);
            this.knxLink.close();
        }
        this.knxLink = null;
        List<GroupAddress> groupAddresses = Arrays.asList(this.groupAddressStateMap.keySet().toArray(new GroupAddress[0]));
        groupAddresses.forEach(groupAddress -> this.onGroupAddressUpdated((GroupAddress)groupAddress, null));
        this.scheduleReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatapointValueConsumer(StateDP datapoint, Consumer<Object> consumer) {
        Map<GroupAddress, List<Pair<StateDP, Consumer<Object>>>> map = this.groupAddressConsumerMap;
        synchronized (map) {
            List groupAddressConsumers = this.groupAddressConsumerMap.computeIfAbsent(datapoint.getMainAddress(), groupAddress -> new ArrayList());
            groupAddressConsumers.add(new Pair((Object)datapoint, consumer));
            Map<GroupAddress, byte[]> map2 = this.groupAddressStateMap;
            synchronized (map2) {
                this.groupAddressStateMap.compute(datapoint.getMainAddress(), (groupAddress, groupValue) -> {
                    if (groupValue == null) {
                        this.getGroupAddressValue(datapoint.getMainAddress(), datapoint.getPriority());
                    } else {
                        this.updateConsumer((byte[])groupValue, datapoint, consumer);
                    }
                    return groupValue;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatapointValueConsumer(StateDP datapoint) {
        Map<GroupAddress, List<Pair<StateDP, Consumer<Object>>>> map = this.groupAddressConsumerMap;
        synchronized (map) {
            this.groupAddressConsumerMap.computeIfPresent(datapoint.getMainAddress(), (groupAddress, datapointConsumerList) -> {
                if (datapointConsumerList.removeIf(datapointConsumer -> datapointConsumer.key == datapoint) && datapointConsumerList.isEmpty()) {
                    datapointConsumerList = null;
                }
                return datapointConsumerList;
            });
        }
    }

    protected void getGroupAddressValue(GroupAddress groupAddress, Priority priority) {
        if (this.knxLink == null || !this.knxLink.isOpen()) {
            LOG.finer("Cannot send read request not currently connected: " + groupAddress);
            return;
        }
        try {
            LOG.finer("Sending read request to KNX group address: " + groupAddress);
            this.knxLink.sendRequest((KNXAddress)groupAddress, priority, DataUnitBuilder.createLengthOptimizedAPDU((int)0, null));
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error sending KNX read request for group address: " + groupAddress, e);
        }
    }

    protected void updateConsumer(byte[] data, StateDP datapoint, Consumer<Object> consumer) {
        Object value = null;
        if (data != null) {
            try {
                value = TypeMapper.toValue((Datapoint)datapoint, data);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Couldn't translate Group address value to DPT type: " + datapoint, ex);
            }
        }
        consumer.accept(value);
    }

    protected synchronized void scheduleReconnect() {
        if (this.reconnectTask != null) {
            return;
        }
        this.onConnectionStatusChanged(ConnectionStatus.WAITING);
        if (this.reconnectDelayMilliseconds < 60000) {
            this.reconnectDelayMilliseconds *= 2;
            this.reconnectDelayMilliseconds = Math.min(60000, this.reconnectDelayMilliseconds);
        }
        LOG.finest("Scheduling reconnection in '" + this.reconnectDelayMilliseconds + "' milliseconds");
        this.reconnectTask = this.executorService.schedule(() -> {
            KNXConnection kNXConnection = this;
            synchronized (kNXConnection) {
                this.reconnectTask = null;
                if (this.connectionStatus != ConnectionStatus.DISCONNECTING && this.connectionStatus != ConnectionStatus.DISCONNECTED) {
                    this.connect();
                }
            }
        }, (long)this.reconnectDelayMilliseconds, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return KNXConnection.class.getSimpleName() + "{gatewayAddress='" + this.gatewayAddress + "', gatewayPort=" + this.gatewayPort + "}";
    }
}

