/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.knx;

import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.openremote.model.asset.agent.AgentLink;

public class KNXAgentLink
extends AgentLink<KNXAgentLink> {
    @NotNull
    @Pattern(regexp="^\\d{1,3}\\.\\d{1,3}$")
    protected @NotNull @Pattern(regexp="^\\d{1,3}\\.\\d{1,3}$") String dpt;
    @Pattern(regexp="^\\d{1,3}/\\d{1,3}/\\d{1,3}$")
    protected @Pattern(regexp="^\\d{1,3}/\\d{1,3}/\\d{1,3}$") String actionGroupAddress;
    @Pattern(regexp="^\\d{1,3}/\\d{1,3}/\\d{1,3}$")
    protected @Pattern(regexp="^\\d{1,3}/\\d{1,3}/\\d{1,3}$") String statusGroupAddress;

    protected KNXAgentLink() {
    }

    public KNXAgentLink(String id, String dpt, String actionGroupAddress, String statusGroupAddress) {
        super(id);
        this.dpt = dpt;
        this.actionGroupAddress = actionGroupAddress;
        this.statusGroupAddress = statusGroupAddress;
    }

    public Optional<String> getDpt() {
        return Optional.ofNullable(this.dpt);
    }

    public KNXAgentLink setDpt(String dpt) {
        this.dpt = dpt;
        return this;
    }

    public Optional<String> getActionGroupAddress() {
        return Optional.ofNullable(this.actionGroupAddress);
    }

    public KNXAgentLink setActionGroupAddress(String actionGroupAddress) {
        this.actionGroupAddress = actionGroupAddress;
        return this;
    }

    public Optional<String> getStatusGroupAddress() {
        return Optional.ofNullable(this.statusGroupAddress);
    }

    public KNXAgentLink setStatusGroupAddress(String statusGroupAddress) {
        this.statusGroupAddress = statusGroupAddress;
        return this;
    }
}

