/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.knx;

import java.util.Optional;
import javax.persistence.Entity;
import javax.validation.constraints.Pattern;
import org.openremote.agent.protocol.knx.KNXAgentLink;
import org.openremote.agent.protocol.knx.KNXProtocol;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueConstraint;
import org.openremote.model.value.ValueDescriptor;
import org.openremote.model.value.ValueType;

@Entity
public class KNXAgent
extends Agent<KNXAgent, KNXProtocol, KNXAgentLink> {
    @Pattern(regexp="^\\d\\.\\d\\.\\d$")
    public static final @Pattern(regexp="^\\d\\.\\d\\.\\d$") ValueDescriptor<String> SOURCE_ADDRESS_VALUE = new ValueDescriptor("kNXMessageSourceAddress", String.class, new ValueConstraint[0]);
    public static final AttributeDescriptor<String> GATEWAY = HOST.withOptional(false);
    public static final AttributeDescriptor<Boolean> NAT_MODE = new AttributeDescriptor("NATMode", ValueType.BOOLEAN);
    public static final AttributeDescriptor<Boolean> ROUTING_MODE = new AttributeDescriptor("routingMode", ValueType.BOOLEAN);
    public static final AttributeDescriptor<String> MESSAGE_SOURCE_ADDRESS = new AttributeDescriptor("messageSourceAddress", SOURCE_ADDRESS_VALUE);
    public static final AgentDescriptor<KNXAgent, KNXProtocol, KNXAgentLink> DESCRIPTOR = new AgentDescriptor(KNXAgent.class, KNXProtocol.class, KNXAgentLink.class);

    protected KNXAgent() {
    }

    public KNXAgent(String name) {
        super(name);
    }

    public Optional<String> getMessageSourceAddress() {
        return this.getAttributes().getValue(MESSAGE_SOURCE_ADDRESS);
    }

    public KNXAgent setMessageSourceAddress(String value) {
        this.getAttributes().getOrCreate(MESSAGE_SOURCE_ADDRESS).setValue((Object)value);
        return this;
    }

    public Optional<Boolean> isNATMode() {
        return this.getAttributes().getValue(NAT_MODE);
    }

    public KNXAgent setNATMode(Boolean value) {
        this.getAttributes().getOrCreate(NAT_MODE).setValue((Object)value);
        return this;
    }

    public Optional<Boolean> isRoutingMode() {
        return this.getAttributes().getValue(ROUTING_MODE);
    }

    public KNXAgent setRoutingMode(Boolean value) {
        this.getAttributes().getOrCreate(ROUTING_MODE).setValue((Object)value);
        return this;
    }

    public KNXProtocol getProtocolInstance() {
        return new KNXProtocol(this);
    }
}

