/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.knx;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.openremote.agent.protocol.knx.KNXProtocol;
import org.openremote.model.syslog.SyslogCategory;

public class ETSFileURIResolver
implements URIResolver {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, KNXProtocol.class);
    private byte[] data;

    public ETSFileURIResolver(byte[] fileData) {
        this.data = fileData;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(this.data));
        ZipEntry zipEntry = null;
        try {
            zipEntry = zin.getNextEntry();
            String entryData = null;
            while (zipEntry != null) {
                if (zipEntry.getName().equals(href)) {
                    entryData = ETSFileURIResolver.convertStreamToString(zin);
                    break;
                }
                zipEntry = zin.getNextEntry();
            }
            return new StreamSource(new ByteArrayInputStream(entryData.getBytes()));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Could not create XML Stream Source for '" + href + "' from ETS project file.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

