/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.io;

import java.net.SocketAddress;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openremote.model.asset.agent.ConnectionStatus;

public interface IOServer<T, U, V extends SocketAddress> {
    public void sendMessage(T var1, U var2);

    public void sendMessage(T var1);

    public void addMessageConsumer(IoServerMessageConsumer<T, U, V> var1);

    public void removeMessageConsumer(IoServerMessageConsumer<T, U, V> var1);

    public void removeAllMessageConsumers();

    public void addConnectionStatusConsumer(Consumer<ConnectionStatus> var1);

    public void removeConnectionStatusConsumer(Consumer<ConnectionStatus> var1);

    public void addConnectionStatusConsumer(BiConsumer<U, ConnectionStatus> var1);

    public void removeConnectionStatusConsumer(BiConsumer<U, ConnectionStatus> var1);

    public void removeAllConnectionStatusConsumers();

    public ConnectionStatus getConnectionStatus();

    public ConnectionStatus getConnectionStatus(U var1);

    public void disconnectClient(U var1);

    public void start();

    public void stop();

    @FunctionalInterface
    public static interface IoServerMessageConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

