/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.FixedLengthFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.io.IOAgent;
import org.openremote.agent.protocol.io.IOClient;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.protocol.ProtocolUtil;
import org.openremote.model.syslog.SyslogCategory;

public abstract class AbstractIOClientProtocol<T extends AbstractIOClientProtocol<T, U, V, W, X>, U extends IOAgent<U, T, X>, V, W extends IOClient<V>, X extends AgentLink<?>>
extends AbstractProtocol<U, X> {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, AbstractIOClientProtocol.class);
    protected W client;

    public static Supplier<ChannelHandler[]> getGenericStringEncodersAndDecoders(AbstractNettyIOClient<String, ?> client, IOAgent<?, ?, ?> agent) {
        boolean hexMode = agent.getMessageConvertHex().orElse(false);
        boolean binaryMode = agent.getMessageConvertBinary().orElse(false);
        Charset charset = agent.getMessageCharset().map(Charset::forName).orElse(CharsetUtil.UTF_8);
        int maxLength = agent.getMessageMaxLength().orElse(Integer.MAX_VALUE);
        String[] delimiters = agent.getMessageDelimiters().orElse(new String[0]);
        boolean stripDelimiter = agent.getMessageStripDelimiter().orElse(false);
        return () -> {
            ArrayList<Object> encodersDecoders = new ArrayList<Object>();
            if (hexMode || binaryMode) {
                encodersDecoders.add(new AbstractNettyIOClient.MessageToByteEncoder<String>(String.class, client, (msg, out) -> {
                    byte[] bytes = hexMode ? ProtocolUtil.bytesFromHexString((String)msg) : ProtocolUtil.bytesFromBinaryString((String)msg);
                    out.writeBytes(bytes);
                }));
                if (delimiters.length > 0) {
                    ByteBuf[] byteDelimiters = (ByteBuf[])Arrays.stream(delimiters).map(delim -> Unpooled.wrappedBuffer((byte[])(hexMode ? ProtocolUtil.bytesFromHexString((String)delim) : ProtocolUtil.bytesFromBinaryString((String)delim)))).toArray(ByteBuf[]::new);
                    encodersDecoders.add(new DelimiterBasedFrameDecoder(maxLength, stripDelimiter, byteDelimiters));
                } else {
                    encodersDecoders.add(new FixedLengthFrameDecoder(maxLength));
                }
                encodersDecoders.add((Object)new AbstractNettyIOClient.ByteToMessageDecoder(client, (byteBuf, messages) -> {
                    byte[] bytes = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(bytes);
                    String msg = hexMode ? ProtocolUtil.bytesToHexString((byte[])bytes) : ProtocolUtil.bytesToBinaryString((byte[])bytes);
                    messages.add(msg);
                }));
            } else {
                encodersDecoders.add(new StringEncoder(charset));
                if (agent.getMessageMaxLength().isPresent()) {
                    encodersDecoders.add(new FixedLengthFrameDecoder(maxLength));
                } else {
                    ByteBuf[] byteDelimiters = delimiters.length > 0 ? (ByteBuf[])Arrays.stream(delimiters).map(delim -> Unpooled.wrappedBuffer((byte[])delim.getBytes(charset))).toArray(ByteBuf[]::new) : Delimiters.lineDelimiter();
                    encodersDecoders.add(new DelimiterBasedFrameDecoder(maxLength, stripDelimiter, byteDelimiters));
                }
                encodersDecoders.add(new StringDecoder(charset));
                encodersDecoders.add(new AbstractNettyIOClient.MessageToMessageDecoder<String>(String.class, client));
            }
            return encodersDecoders.toArray(new ChannelHandler[0]);
        };
    }

    protected AbstractIOClientProtocol(U agent) {
        super(agent);
    }

    public String getProtocolInstanceUri() {
        return this.client != null ? this.client.getClientUri() : "";
    }

    @Override
    protected void doStop(Container container) throws Exception {
        if (this.client != null) {
            LOG.fine("Stopping IO client for protocol: " + this);
            this.client.removeAllMessageConsumers();
            this.client.removeAllConnectionStatusConsumers();
            LOG.info("Disconnecting IO client");
            this.client.disconnect();
        }
        this.client = null;
    }

    @Override
    protected void doStart(Container container) throws Exception {
        try {
            this.client = this.createIoClient();
            LOG.fine("Created IO client '" + this.client.getClientUri() + "' for protocol: " + this);
            this.client.connect();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to create IO client for protocol: " + this, e);
            this.setConnectionStatus(ConnectionStatus.ERROR);
        }
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, X agentLink, AttributeEvent event, Object processedValue) {
        if (this.client == null || attribute == null) {
            return;
        }
        V message = this.createWriteMessage(attribute, ((IOAgent)this.agent).getAgentLink(attribute), event, processedValue);
        if (message == null) {
            LOG.fine("No message produced for attribute event so not sending to IO client '" + this.client.getClientUri() + "': " + event);
            return;
        }
        LOG.finer("Sending message to IO client: " + this.client.getClientUri());
        this.client.sendMessage(message);
    }

    protected W createIoClient() throws Exception {
        W client = this.doCreateIoClient();
        if (client == null) {
            throw new IllegalStateException("IO client for protocol should not be null");
        }
        client.addConnectionStatusConsumer(this::onConnectionStatusChanged);
        client.addMessageConsumer(this::onMessageReceived);
        this.client = client;
        return client;
    }

    protected void onConnectionStatusChanged(ConnectionStatus connectionStatus) {
        this.setConnectionStatus(connectionStatus);
    }

    protected abstract W doCreateIoClient() throws Exception;

    protected abstract void onMessageReceived(V var1);

    protected abstract V createWriteMessage(Attribute<?> var1, X var2, AttributeEvent var3, Object var4);
}

