/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.http.client.utils.URIBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.http.HTTPAgent;
import org.openremote.agent.protocol.http.HTTPAgentLink;
import org.openremote.agent.protocol.http.PaginationFilter;
import org.openremote.container.concurrent.GlobalLock;
import org.openremote.container.web.QueryParameterInjectorFilter;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.protocol.ProtocolUtil;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class HTTPProtocol
extends AbstractProtocol<HTTPAgent, HTTPAgentLink> {
    public static final String PROTOCOL_DISPLAY_NAME = "HTTP Client";
    public static final String DEFAULT_HTTP_METHOD = "GET";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    protected static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, HTTPProtocol.class);
    public static int MIN_POLLING_MILLIS = 5000;
    protected static ResteasyClient client = WebTargetBuilder.createClient((ExecutorService)org.openremote.container.Container.EXECUTOR_SERVICE);
    protected final Map<AttributeRef, HttpClientRequest> requestMap = new HashMap<AttributeRef, HttpClientRequest>();
    protected final Map<AttributeRef, ScheduledFuture<?>> pollingMap = new HashMap();
    protected final Map<AttributeRef, Set<AttributeRef>> pollingLinkedAttributeMap = new HashMap<AttributeRef, Set<AttributeRef>>();
    protected ResteasyWebTarget webTarget;

    public HTTPProtocol(HTTPAgent agent) {
        super(agent);
    }

    @Override
    protected void doStop(Container container) {
        this.pollingMap.forEach((attributeRef, scheduledFuture) -> scheduledFuture.cancel(true));
        this.pollingMap.clear();
        this.requestMap.clear();
    }

    @Override
    protected void doStart(Container container) throws Exception {
        URI uri;
        String baseUri = ((HTTPAgent)this.agent).getBaseURI().orElseThrow(() -> new IllegalArgumentException("Missing or invalid base URI attribute: " + this));
        if (baseUri.endsWith("/")) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        try {
            uri = new URIBuilder(baseUri).build();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.SEVERE, "Invalid URI", e);
            throw e;
        }
        Optional oAuthGrant = ((HTTPAgent)this.agent).getOAuthGrant();
        Optional usernameAndPassword = ((HTTPAgent)this.agent).getUsernamePassword();
        boolean followRedirects = ((HTTPAgent)this.agent).getFollowRedirects().orElse(false);
        Optional<ValueType.MultivaluedStringMap> headers = ((HTTPAgent)this.agent).getRequestHeaders();
        Optional<ValueType.MultivaluedStringMap> queryParams = ((HTTPAgent)this.agent).getRequestQueryParameters();
        Integer readTimeout = ((HTTPAgent)this.agent).getRequestTimeoutMillis().orElse(null);
        WebTargetBuilder webTargetBuilder = readTimeout != null ? new WebTargetBuilder(WebTargetBuilder.createClient((ExecutorService)this.executorService, (int)10, (long)readTimeout.longValue(), null), uri) : new WebTargetBuilder(client, uri);
        if (oAuthGrant.isPresent()) {
            LOG.info("Adding OAuth");
            webTargetBuilder.setOAuthAuthentication((OAuthGrant)oAuthGrant.get());
        } else {
            usernameAndPassword.ifPresent(userPass -> {
                LOG.info("Adding Basic Authentication");
                webTargetBuilder.setBasicAuthentication(userPass.getUsername(), userPass.getPassword());
            });
        }
        headers.ifPresent(arg_0 -> ((WebTargetBuilder)webTargetBuilder).setInjectHeaders(arg_0));
        queryParams.ifPresent(arg_0 -> ((WebTargetBuilder)webTargetBuilder).setInjectQueryParameters(arg_0));
        webTargetBuilder.followRedirects(followRedirects);
        LOG.fine("Creating web target client '" + baseUri + "'");
        this.webTarget = webTargetBuilder.build();
        this.setConnectionStatus(ConnectionStatus.CONNECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, HTTPAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        String method = agentLink.getMethod().map(Enum::name).orElse(DEFAULT_HTTP_METHOD);
        String path = agentLink.getPath().orElse(null);
        String contentType = agentLink.getContentType().orElse(null);
        Map headers = agentLink.getHeaders().orElse(null);
        Map queryParams = agentLink.getQueryParameters().orElse(null);
        Integer pollingMillis = agentLink.getPollingMillis().map(millis -> Math.max(millis, MIN_POLLING_MILLIS)).orElse(null);
        boolean pagingEnabled = agentLink.getPagingMode().orElse(false);
        String pollingAttribute = agentLink.getPollingAttribute().orElse(null);
        if (!TextUtil.isNullOrEmpty((String)pollingAttribute)) {
            Map<AttributeRef, Set<AttributeRef>> map = this.pollingLinkedAttributeMap;
            synchronized (map) {
                AttributeRef pollingSourceRef = new AttributeRef(attributeRef.getId(), pollingAttribute);
                this.pollingLinkedAttributeMap.compute(pollingSourceRef, (ref, links) -> {
                    if (links == null) {
                        links = new HashSet<AttributeRef>();
                    }
                    links.add(attributeRef);
                    return links;
                });
            }
        }
        String body = agentLink.getWriteValue().orElse(null);
        if (client == null) {
            LOG.warning("Client is undefined: " + this);
            return;
        }
        HttpClientRequest clientRequest = this.buildClientRequest(path, method, (MultivaluedMap<String, Object>)(headers != null ? WebTargetBuilder.mapToMultivaluedMap((Map)headers, (MultivaluedMap)new MultivaluedHashMap()) : null), queryParams != null ? WebTargetBuilder.mapToMultivaluedMap((Map)queryParams, (MultivaluedMap)new MultivaluedHashMap()) : null, pagingEnabled, contentType);
        LOG.fine("Creating HTTP request for attributeRef '" + clientRequest + "': " + attributeRef);
        this.requestMap.put(attributeRef, clientRequest);
        Optional.ofNullable(pollingMillis).ifPresent(seconds -> this.pollingMap.put(attributeRef, this.schedulePollingRequest(attributeRef, agentLink, clientRequest, body, (int)seconds)));
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, HTTPAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        this.requestMap.remove(attributeRef);
        this.cancelPolling(attributeRef);
        agentLink.getPollingMillis().ifPresent(pollingAttribute -> {
            Map<AttributeRef, Set<AttributeRef>> map = this.pollingLinkedAttributeMap;
            synchronized (map) {
                this.pollingLinkedAttributeMap.remove(attributeRef);
                this.pollingLinkedAttributeMap.values().forEach(links -> links.remove(attributeRef));
            }
        });
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, HTTPAgentLink agentLink, AttributeEvent event, Object processedValue) {
        HttpClientRequest request = this.requestMap.get(event.getAttributeRef());
        if (request != null) {
            this.executeAttributeWriteRequest(request, processedValue, response -> this.onAttributeWriteResponse(request, (Response)response));
        } else {
            LOG.finest("Ignoring attribute write request as either attribute or agent is not linked: " + event);
        }
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return this.webTarget != null ? this.webTarget.getUri().toString() : ((HTTPAgent)this.agent).getBaseURI().orElse("");
    }

    protected HttpClientRequest buildClientRequest(String path, String method, MultivaluedMap<String, Object> headers, MultivaluedMap<String, String> queryParams, boolean pagingEnabled, String contentType) {
        return new HttpClientRequest((WebTarget)this.webTarget, path, method, headers, queryParams, pagingEnabled, contentType);
    }

    protected ScheduledFuture<?> schedulePollingRequest(AttributeRef attributeRef, HTTPAgentLink agentLink, HttpClientRequest clientRequest, String body, int pollingMillis) {
        LOG.fine("Scheduling polling request '" + clientRequest + "' to execute every " + pollingMillis + " ms for attribute: " + attributeRef);
        return this.executorService.scheduleWithFixedDelay(() -> this.executePollingRequest(clientRequest, body, response -> {
            try {
                this.onPollingResponse(clientRequest, (Response)response, attributeRef, agentLink);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, this.prefixLogMessage("Exception thrown whilst processing polling response [" + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()) + "]: " + clientRequest.requestTarget.getUriBuilder().build(new Object[0]).toString()));
            }
        }), 0L, pollingMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePollingRequest(HttpClientRequest clientRequest, String body, Consumer<Response> responseConsumer) {
        Response originalResponse = null;
        Response lastResponse = null;
        ArrayList<String> entities = new ArrayList<String>();
        try {
            originalResponse = clientRequest.invoke(body);
            if (clientRequest.pagingEnabled) {
                lastResponse = originalResponse;
                entities.add((String)lastResponse.readEntity(String.class));
                while ((lastResponse = this.executePagingRequest(clientRequest, lastResponse)) != null) {
                    entities.add((String)lastResponse.readEntity(String.class));
                    lastResponse.close();
                }
                originalResponse = PagingResponse.fromResponse(originalResponse).entity(entities).build();
            }
            responseConsumer.accept(originalResponse);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, this.prefixLogMessage("Exception thrown whilst doing polling request [" + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()) + "]: " + clientRequest.requestTarget.getUriBuilder().build(new Object[0]).toString()));
        }
        finally {
            if (originalResponse != null) {
                originalResponse.close();
            }
            if (lastResponse != null) {
                lastResponse.close();
            }
        }
    }

    protected Response executePagingRequest(HttpClientRequest clientRequest, Response response) {
        if (response.hasLink("next")) {
            URI nextUrl = response.getLink("next").getUri();
            return ((WebTarget)clientRequest.client.register((Object)new PaginationFilter(nextUrl))).request().build(clientRequest.method).invoke();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAttributeWriteRequest(HttpClientRequest clientRequest, Object attributeValue, Consumer<Response> responseConsumer) {
        String valueStr = attributeValue == null ? null : (String)ValueUtil.convert((Object)attributeValue, String.class);
        try (Response response = null;){
            response = clientRequest.invoke(valueStr);
            responseConsumer.accept(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPollingResponse(HttpClientRequest request, Response response, AttributeRef attributeRef, HTTPAgentLink agentLink) {
        Object value;
        block10: {
            int responseCode = response != null ? response.getStatus() : 500;
            value = null;
            if (response != null && response.hasEntity() && response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                try {
                    boolean binaryMode = ((HTTPAgent)this.agent).getMessageConvertBinary().orElse(agentLink.isMessageConvertBinary());
                    boolean hexMode = ((HTTPAgent)this.agent).getMessageConvertHex().orElse(agentLink.isMessageConvertHex());
                    if (hexMode || binaryMode) {
                        byte[] bytes = (byte[])response.readEntity(byte[].class);
                        value = hexMode ? ProtocolUtil.bytesToHexString((byte[])bytes) : ProtocolUtil.bytesToBinaryString((byte[])bytes);
                        break block10;
                    }
                    value = response.readEntity(String.class);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error occurred whilst trying to read response body", e);
                    response.close();
                }
            } else {
                LOG.fine(this.prefixLogMessage("Request returned an un-successful response code (" + responseCode + "):" + request.requestTarget.getUriBuilder().build(new Object[0]).toString()));
                return;
            }
        }
        if (attributeRef != null) {
            this.updateLinkedAttribute(new AttributeState(attributeRef, value));
            Map<AttributeRef, Set<AttributeRef>> map = this.pollingLinkedAttributeMap;
            synchronized (map) {
                Set<AttributeRef> linkedRefs = this.pollingLinkedAttributeMap.get(attributeRef);
                if (linkedRefs != null) {
                    Object finalValue = value;
                    linkedRefs.forEach(ref -> this.updateLinkedAttribute(new AttributeState(ref, finalValue)));
                }
            }
        }
    }

    protected void onAttributeWriteResponse(HttpClientRequest request, Response response) {
        if (response != null && response.hasEntity() && response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            LOG.fine(this.prefixLogMessage("Attribute write request returned an unsuccessful response code (" + response.getStatus() + "): " + request.requestTarget.getUriBuilder().build(new Object[0]).toString()));
        }
    }

    protected void cancelPolling(AttributeRef attributeRef) {
        GlobalLock.withLock((String)(this.getProtocolName() + "::cancelPolling"), () -> {
            ScheduledFuture<?> pollTask = this.pollingMap.remove(attributeRef);
            if (pollTask != null) {
                pollTask.cancel(false);
            }
        });
    }

    public static class HttpClientRequest {
        public String method;
        public MultivaluedMap<String, Object> headers;
        public MultivaluedMap<String, String> queryParameters;
        public String path;
        protected String contentType;
        protected WebTarget client;
        protected WebTarget requestTarget;
        protected boolean dynamicQueryParameters;
        protected boolean pagingEnabled;

        public HttpClientRequest(WebTarget client, String path, String method, MultivaluedMap<String, Object> headers, MultivaluedMap<String, String> queryParameters, boolean pagingEnabled, String contentType) {
            boolean dynamicPath;
            if (!TextUtil.isNullOrEmpty((String)path) && path.startsWith("/")) {
                path = path.substring(1);
            }
            this.client = client;
            this.path = path;
            this.method = method != null ? method : HTTPProtocol.DEFAULT_HTTP_METHOD;
            this.headers = headers;
            this.queryParameters = queryParameters;
            this.pagingEnabled = pagingEnabled;
            this.contentType = contentType != null ? contentType : HTTPProtocol.DEFAULT_CONTENT_TYPE;
            this.dynamicQueryParameters = queryParameters != null && queryParameters.entrySet().stream().anyMatch(paramNameAndValues -> paramNameAndValues.getValue() != null && ((List)paramNameAndValues.getValue()).stream().anyMatch(val -> val.contains("{$value}")));
            boolean bl = dynamicPath = !TextUtil.isNullOrEmpty((String)path) && path.contains("{$value}");
            if (!dynamicPath) {
                this.requestTarget = this.createRequestTarget(path);
            }
        }

        protected WebTarget createRequestTarget(String path) {
            WebTarget requestTarget = this.client.path(path == null ? "" : path);
            if (this.queryParameters != null) {
                MultivaluedMap existingParams = (MultivaluedMap)requestTarget.getConfiguration().getProperty(QueryParameterInjectorFilter.QUERY_PARAMETERS_PROPERTY);
                existingParams = existingParams != null ? new MultivaluedHashMap(existingParams) : new MultivaluedHashMap();
                this.queryParameters.forEach((arg_0, arg_1) -> ((MultivaluedMap)existingParams).addAll(arg_0, arg_1));
                requestTarget.property(QueryParameterInjectorFilter.QUERY_PARAMETERS_PROPERTY, (Object)existingParams);
            }
            return requestTarget;
        }

        protected Invocation.Builder getRequestBuilder(String value) {
            Invocation.Builder requestBuilder;
            if (this.requestTarget != null) {
                requestBuilder = this.requestTarget.request();
            } else {
                String path = this.path.replaceAll("\"?\\{\\$value}\"?", value);
                requestBuilder = this.createRequestTarget(path).request();
            }
            if (this.headers != null) {
                requestBuilder.headers(this.headers);
            }
            if (this.dynamicQueryParameters) {
                requestBuilder.property(QueryParameterInjectorFilter.DYNAMIC_VALUE_PROPERTY, (Object)value);
            }
            return requestBuilder;
        }

        protected Invocation buildInvocation(Invocation.Builder requestBuilder, String value) {
            if (this.dynamicQueryParameters) {
                requestBuilder.property(QueryParameterInjectorFilter.DYNAMIC_VALUE_PROPERTY, (Object)value);
            }
            Invocation invocation = this.method != null && !HTTPProtocol.DEFAULT_HTTP_METHOD.equals(this.method) && value != null ? requestBuilder.build(this.method, Entity.entity((Object)value, (String)this.contentType)) : requestBuilder.build(this.method);
            return invocation;
        }

        public Response invoke(String value) {
            Invocation.Builder requestBuilder = this.getRequestBuilder(value);
            Invocation invocation = this.buildInvocation(requestBuilder, value);
            return invocation.invoke();
        }

        public String toString() {
            return this.client.getUri() + (String)(this.path != null ? "/" + this.path : "");
        }
    }

    protected static class PagingResponse
    extends BuiltResponse {
        private PagingResponse(int status, Headers<Object> metadata, Object entity, Annotation[] entityAnnotations) {
            super(status, metadata, entity, entityAnnotations);
        }

        public static Response.ResponseBuilder fromResponse(Response response) {
            Response.ResponseBuilder b = new PagingResponseBuilder().status(response.getStatus());
            for (String headerName : response.getHeaders().keySet()) {
                List headerValues = (List)response.getHeaders().get((Object)headerName);
                for (Object headerValue : headerValues) {
                    b.header(headerName, headerValue);
                }
            }
            return b;
        }

        public <T> T readEntity(Class<T> type) {
            return (T)this.entity;
        }

        public <T> T readEntity(Class<T> type, Type genericType, Annotation[] anns) {
            return (T)this.entity;
        }
    }

    protected static class PagingResponseBuilder
    extends ResponseBuilderImpl {
        protected PagingResponseBuilder() {
        }

        public Response build() {
            if (this.status == -1 && this.entity == null) {
                this.status = 204;
            } else if (this.status == -1) {
                this.status = 200;
            }
            return new PagingResponse(this.status, (Headers<Object>)this.metadata, this.entity, this.entityAnnotations);
        }
    }
}

