/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.http;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openremote.agent.protocol.http.HTTPMethod;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.value.ValueType;

public class HTTPAgentLink
extends AgentLink<HTTPAgentLink> {
    @JsonPropertyDescription(value="A JSON object of headers to be added to HTTP request; the key represents the name of the header and for each string value supplied a new header will be added with the key name and specified string value")
    protected Map<String, List<String>> headers;
    @JsonPropertyDescription(value="A JSON object of query parameters to be added to HTTP request URL; the key represents the name of the query parameter and for each string value supplied a new query parameter will be added with the key name and specified string value (e.g. 'https://..../?test=1&test=2')")
    protected Map<String, List<String>> queryParameters;
    @JsonPropertyDescription(value="Indicates that this HTTP request is used to update the linked attribute; this value indicates how frequently the HTTP request is made in order to update the linked attribute value")
    protected Integer pollingMillis;
    @JsonPropertyDescription(value="Indicates that the HTTP server supports pagination using the standard Link header mechanism")
    protected Boolean pagingMode;
    @JsonPropertyDescription(value="The URL path to append to the agents Base URL when making requests for this linked attribute")
    protected String path;
    @JsonPropertyDescription(value="The HTTP method to use when making requests for this linked attribute")
    protected HTTPMethod method;
    @JsonPropertyDescription(value="The content type header value to use when making requests for this linked attribute (shortcut alternative to using headers parameter)")
    protected String contentType;
    @JsonPropertyDescription(value="Allows the polled response to be written to another attribute with the specified name on the same asset as the linked attribute")
    protected String pollingAttribute;
    @JsonPropertyDescription(value="Indicates that the HTTP response is binary and should be converted to binary string representation")
    protected boolean messageConvertBinary;
    @JsonPropertyDescription(value="Indicates that the HTTP response is binary and should be converted to hexidecimal string representation")
    protected boolean messageConvertHex;

    protected HTTPAgentLink() {
    }

    public HTTPAgentLink(String id) {
        super(id);
    }

    public Optional<Map<String, List<String>>> getHeaders() {
        return Optional.ofNullable(this.headers);
    }

    public HTTPAgentLink setHeaders(ValueType.MultivaluedStringMap headers) {
        this.headers = headers;
        return this;
    }

    public Optional<Map<String, List<String>>> getQueryParameters() {
        return Optional.ofNullable(this.queryParameters);
    }

    public HTTPAgentLink setQueryParameters(ValueType.MultivaluedStringMap queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public Optional<Integer> getPollingMillis() {
        return Optional.ofNullable(this.pollingMillis);
    }

    public HTTPAgentLink setPollingMillis(Integer pollingMillis) {
        this.pollingMillis = pollingMillis;
        return this;
    }

    public Optional<Boolean> getPagingMode() {
        return Optional.ofNullable(this.pagingMode);
    }

    public HTTPAgentLink setPagingMode(Boolean pagingMode) {
        this.pagingMode = pagingMode;
        return this;
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public HTTPAgentLink setPath(String path) {
        this.path = path;
        return this;
    }

    public Optional<HTTPMethod> getMethod() {
        return Optional.ofNullable(this.method);
    }

    public HTTPAgentLink setMethod(HTTPMethod method) {
        this.method = method;
        return this;
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public HTTPAgentLink setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Optional<String> getPollingAttribute() {
        return Optional.ofNullable(this.pollingAttribute);
    }

    public HTTPAgentLink setPollingAttribute(String pollingAttribute) {
        this.pollingAttribute = pollingAttribute;
        return this;
    }

    public boolean isMessageConvertBinary() {
        return this.messageConvertBinary;
    }

    public HTTPAgentLink setMessageConvertBinary(boolean messageConvertBinary) {
        this.messageConvertBinary = messageConvertBinary;
        return this;
    }

    public boolean isMessageConvertHex() {
        return this.messageConvertHex;
    }

    public HTTPAgentLink setMessageConvertHex(boolean messageConvertHex) {
        this.messageConvertHex = messageConvertHex;
        return this;
    }
}

