/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.http;

import java.util.Optional;
import javax.persistence.Entity;
import org.openremote.agent.protocol.http.HTTPAgentLink;
import org.openremote.agent.protocol.http.HTTPMethod;
import org.openremote.agent.protocol.http.HTTPProtocol;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueConstraint;
import org.openremote.model.value.ValueDescriptor;
import org.openremote.model.value.ValueType;

@Entity
public class HTTPAgent
extends Agent<HTTPAgent, HTTPProtocol, HTTPAgentLink> {
    public static final ValueDescriptor<HTTPMethod> VALUE_HTTP_METHOD = new ValueDescriptor("HTTPMethod", HTTPMethod.class, new ValueConstraint[0]);
    public static final AttributeDescriptor<String> BASE_URI = new AttributeDescriptor("baseURL", ValueType.HTTP_URL);
    public static final AttributeDescriptor<Boolean> FOLLOW_REDIRECTS = new AttributeDescriptor("followRedirects", ValueType.BOOLEAN);
    public static final AttributeDescriptor<ValueType.MultivaluedStringMap> REQUEST_HEADERS = new AttributeDescriptor("requestHeaders", ValueType.MULTIVALUED_TEXT_MAP);
    public static final AttributeDescriptor<ValueType.MultivaluedStringMap> REQUEST_QUERY_PARAMETERS = new AttributeDescriptor("requestQueryParameters", ValueType.MULTIVALUED_TEXT_MAP);
    public static final AttributeDescriptor<Integer> REQUEST_TIMEOUT_MILLIS = new AttributeDescriptor("requestTimeoutMillis", ValueType.POSITIVE_INTEGER);
    public static final AgentDescriptor<HTTPAgent, HTTPProtocol, HTTPAgentLink> DESCRIPTOR = new AgentDescriptor(HTTPAgent.class, HTTPProtocol.class, HTTPAgentLink.class);

    protected HTTPAgent() {
    }

    public HTTPAgent(String name) {
        super(name);
    }

    public Optional<String> getBaseURI() {
        return this.getAttributes().getValue(BASE_URI);
    }

    public HTTPAgent setBaseURI(String value) {
        this.getAttributes().getOrCreate(BASE_URI).setValue((Object)value);
        return this;
    }

    public Optional<Boolean> getFollowRedirects() {
        return this.getAttributes().getValue(FOLLOW_REDIRECTS);
    }

    public HTTPAgent setFollowRedirects(Boolean value) {
        this.getAttributes().getOrCreate(FOLLOW_REDIRECTS).setValue((Object)value);
        return this;
    }

    public Optional<ValueType.MultivaluedStringMap> getRequestHeaders() {
        return this.getAttributes().getValue(REQUEST_HEADERS);
    }

    public HTTPAgent setRequestHeaders(ValueType.MultivaluedStringMap value) {
        this.getAttributes().getOrCreate(REQUEST_HEADERS).setValue((Object)value);
        return this;
    }

    public Optional<ValueType.MultivaluedStringMap> getRequestQueryParameters() {
        return this.getAttributes().getValue(REQUEST_QUERY_PARAMETERS);
    }

    public HTTPAgent setRequestQueryParameters(ValueType.MultivaluedStringMap value) {
        this.getAttributes().getOrCreate(REQUEST_QUERY_PARAMETERS).setValue((Object)value);
        return this;
    }

    public Optional<Integer> getRequestTimeoutMillis() {
        return this.getAttributes().getValue(REQUEST_TIMEOUT_MILLIS);
    }

    public HTTPAgent setRequestTimeoutMillis(Integer value) {
        this.getAttributes().getOrCreate(REQUEST_TIMEOUT_MILLIS).setValue((Object)value);
        return this;
    }

    public Optional<Boolean> getMessageConvertHex() {
        return this.getAttributes().getValue((AbstractNameValueDescriptorHolder)MESSAGE_CONVERT_HEX);
    }

    public HTTPAgent setMessageConvertHex(Boolean value) {
        this.getAttributes().getOrCreate(MESSAGE_CONVERT_HEX).setValue((Object)value);
        return this;
    }

    public Optional<Boolean> getMessageConvertBinary() {
        return this.getAttributes().getValue((AbstractNameValueDescriptorHolder)MESSAGE_CONVERT_BINARY);
    }

    public HTTPAgent setMessageConvertBinary(Boolean value) {
        this.getAttributes().getOrCreate(MESSAGE_CONVERT_BINARY).setValue((Object)value);
        return this;
    }

    public HTTPProtocol getProtocolInstance() {
        return new HTTPProtocol(this);
    }
}

