/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.http;

import com.google.common.collect.Lists;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.interceptors.CorsFilter;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.http.AbstractHTTPServerAgent;
import org.openremote.agent.protocol.http.HTTPMethod;
import org.openremote.container.json.JacksonConfig;
import org.openremote.container.security.IdentityService;
import org.openremote.container.web.AlreadyGzippedWriterInterceptor;
import org.openremote.container.web.ClientErrorExceptionHandler;
import org.openremote.container.web.WebApplication;
import org.openremote.container.web.WebService;
import org.openremote.container.web.WebServiceExceptions;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;

public abstract class AbstractHTTPServerProtocol<T extends AbstractHTTPServerProtocol<T, U, V>, U extends AbstractHTTPServerAgent<U, T, V>, V extends AgentLink<?>>
extends AbstractProtocol<U, V> {
    public static final String DEFAULT_DEPLOYMENT_PATH_PREFIX = "/rest";
    public static final Pattern PATH_REGEX = Pattern.compile("^[\\w/_]+$", 2);
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, AbstractHTTPServerProtocol.class);
    public static final HTTPMethod[] DEFAULT_ALLOWED_METHODS = HTTPMethod.values();
    protected DeploymentInstance deployment;
    protected static WebServiceExceptions.DefaultResteasyExceptionMapper defaultResteasyExceptionMapper;
    protected static WebServiceExceptions.ForbiddenResteasyExceptionMapper forbiddenResteasyExceptionMapper;
    protected static JacksonConfig jacksonConfig;
    protected static AlreadyGzippedWriterInterceptor alreadyGzippedWriterInterceptor;
    protected static ClientErrorExceptionHandler clientErrorExceptionHandler;
    protected static WebServiceExceptions.ServletUndertowExceptionHandler undertowExceptionHandler;
    protected Container container;
    protected boolean devMode;
    protected IdentityService identityService;
    protected WebService webService;

    public AbstractHTTPServerProtocol(U agent) {
        super(agent);
    }

    @Override
    public void doStart(Container container) throws Exception {
        this.container = container;
        this.devMode = container.isDevMode();
        this.identityService = container.hasService(IdentityService.class) ? (IdentityService)container.getService(IdentityService.class) : null;
        this.webService = (WebService)container.getService(WebService.class);
        if (defaultResteasyExceptionMapper == null) {
            defaultResteasyExceptionMapper = new WebServiceExceptions.DefaultResteasyExceptionMapper(this.devMode);
            forbiddenResteasyExceptionMapper = new WebServiceExceptions.ForbiddenResteasyExceptionMapper(this.devMode);
            undertowExceptionHandler = new WebServiceExceptions.ServletUndertowExceptionHandler(this.devMode);
            jacksonConfig = new JacksonConfig();
            alreadyGzippedWriterInterceptor = new AlreadyGzippedWriterInterceptor();
            clientErrorExceptionHandler = new ClientErrorExceptionHandler();
        }
        Application application = this.createApplication();
        ResteasyDeployment deployment = this.createDeployment(application);
        DeploymentInfo deploymentInfo = this.createDeploymentInfo(deployment);
        this.configureDeploymentInfo(deploymentInfo);
        this.deploy(deploymentInfo);
    }

    @Override
    protected void doStop(Container container) throws Exception {
        this.undeploy();
    }

    protected Application createApplication() {
        ArrayList<Object> providers = this.getStandardProviders();
        providers = providers == null ? new ArrayList<Object>() : providers;
        providers.addAll(this.getApiSingletons());
        return new WebApplication(this.container, null, providers);
    }

    protected ResteasyDeployment createDeployment(Application application) {
        ResteasyDeployment resteasyDeployment = new ResteasyDeployment();
        resteasyDeployment.setApplication(application);
        List allowedOrigins = this.devMode ? Collections.singletonList("*") : (List)((AbstractHTTPServerAgent)this.agent).getAllowedOrigins().map(Arrays::asList).orElse(null);
        if (allowedOrigins != null) {
            String allowedMethods = Arrays.stream(((AbstractHTTPServerAgent)this.agent).getAllowedHTTPMethods().orElse(DEFAULT_ALLOWED_METHODS)).map(Enum::name).collect(Collectors.joining(","));
            CorsFilter corsFilter = new CorsFilter();
            corsFilter.getAllowedOrigins().addAll(allowedOrigins);
            corsFilter.setAllowedMethods(allowedMethods);
            resteasyDeployment.getProviders().add(corsFilter);
        }
        return resteasyDeployment;
    }

    protected DeploymentInfo createDeploymentInfo(ResteasyDeployment resteasyDeployment) {
        String deploymentPath = this.getDeploymentPath();
        String deploymentName = this.getDeploymentName();
        boolean enableSecurity = ((AbstractHTTPServerAgent)this.agent).isRoleBasedSecurity().orElse(false);
        if (enableSecurity && this.identityService == null) {
            throw new RuntimeException("Role based security can only be enabled when an identity service is available");
        }
        resteasyDeployment.setSecurityEnabled(enableSecurity);
        ServletInfo resteasyServlet = Servlets.servlet((String)"ResteasyServlet", HttpServlet30Dispatcher.class).setAsyncSupported(true).setLoadOnStartup(Integer.valueOf(1)).addMapping("/*");
        DeploymentInfo deploymentInfo = new DeploymentInfo().setDeploymentName(deploymentName).setContextPath(deploymentPath).addServletContextAttribute(ResteasyDeployment.class.getName(), (Object)resteasyDeployment).addServlet(resteasyServlet).setClassLoader(Container.class.getClassLoader());
        if (enableSecurity) {
            this.identityService.secureDeployment(deploymentInfo);
        }
        return deploymentInfo;
    }

    protected abstract Set<Object> getApiSingletons();

    protected String getDeploymentPathPrefix() {
        return DEFAULT_DEPLOYMENT_PATH_PREFIX;
    }

    protected String getDeploymentPath() throws IllegalArgumentException {
        String path = ((AbstractHTTPServerAgent)this.agent).getDeploymentPath().map(String::toLowerCase).orElseThrow(() -> new IllegalArgumentException("Required deployment path attribute is missing or invalid: " + this.agent));
        String deploymentPath = this.getDeploymentPathPrefix() + "/" + path;
        if (!PATH_REGEX.matcher(deploymentPath).find()) {
            throw new IllegalArgumentException("Required deployment path attribute is missing or invalid: " + this.agent);
        }
        return deploymentPath;
    }

    protected List<Object> getStandardProviders() {
        return Lists.newArrayList((Object[])new Object[]{defaultResteasyExceptionMapper, forbiddenResteasyExceptionMapper, jacksonConfig, alreadyGzippedWriterInterceptor, clientErrorExceptionHandler});
    }

    protected void configureDeploymentInfo(DeploymentInfo deploymentInfo) {
        deploymentInfo.setExceptionHandler((ExceptionHandler)undertowExceptionHandler);
    }

    protected String getDeploymentName() {
        return "HttpServerProtocol=" + this.getClass().getSimpleName() + ",  Agent ID=" + ((AbstractHTTPServerAgent)this.agent).getId();
    }

    protected void deploy(DeploymentInfo deploymentInfo) {
        LOG.info("Deploying JAX-RS deployment for protocol instance : " + this);
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(deploymentInfo);
        manager.deploy();
        String agentRealm = ((AbstractHTTPServerAgent)this.agent).getRealm();
        if (TextUtil.isNullOrEmpty((String)agentRealm)) {
            throw new IllegalStateException("Cannot determine the realm that this agent belongs to");
        }
        try {
            HttpHandler httpHandler = manager.start();
            HttpHandler handlerWrapper = exchange -> {
                exchange.getRequestHeaders().put(HttpString.tryFromString((String)"Realm"), agentRealm);
                httpHandler.handleRequest(exchange);
            };
            WebService.RequestHandler requestHandler = WebService.pathStartsWithHandler((String)deploymentInfo.getDeploymentName(), (String)deploymentInfo.getContextPath(), (HttpHandler)handlerWrapper);
            LOG.info("Registering HTTP Server Protocol request handler '" + this.getClass().getSimpleName() + "' for request path: " + deploymentInfo.getContextPath());
            this.webService.getRequestHandlers().add(0, requestHandler);
            this.deployment = new DeploymentInstance(deploymentInfo, requestHandler);
        }
        catch (ServletException e) {
            LOG.severe("Failed to deploy deployment: " + deploymentInfo.getDeploymentName());
        }
    }

    protected void undeploy() {
        if (this.deployment == null) {
            LOG.info("Deployment doesn't exist for protocol instance: " + this);
            return;
        }
        try {
            LOG.info("Un-registering HTTP Server Protocol request handler '" + this.getClass().getSimpleName() + "' for request path: " + this.deployment.deploymentInfo.getContextPath());
            this.webService.getRequestHandlers().remove(this.deployment.requestHandler);
            DeploymentManager manager = Servlets.defaultContainer().getDeployment(this.deployment.deploymentInfo.getDeploymentName());
            if (manager != null) {
                manager.stop();
                manager.undeploy();
            }
            Servlets.defaultContainer().removeDeployment(this.deployment.deploymentInfo);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "An exception occurred whilst un-deploying protocol instance: " + this, ex);
            throw new RuntimeException(ex);
        }
    }

    public String getProtocolInstanceUri() {
        return "httpServer://" + this.getDeploymentPath();
    }

    public static class DeploymentInstance {
        protected DeploymentInfo deploymentInfo;
        protected WebService.RequestHandler requestHandler;

        public DeploymentInstance(DeploymentInfo deploymentInfo, WebService.RequestHandler requestHandler) {
            this.deploymentInfo = deploymentInfo;
            this.requestHandler = requestHandler;
        }
    }
}

