/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.http;

import java.util.Optional;
import org.openremote.agent.protocol.http.AbstractHTTPServerProtocol;
import org.openremote.agent.protocol.http.HTTPAgent;
import org.openremote.agent.protocol.http.HTTPMethod;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueType;

public abstract class AbstractHTTPServerAgent<T extends AbstractHTTPServerAgent<T, U, V>, U extends AbstractHTTPServerProtocol<U, T, V>, V extends AgentLink<?>>
extends Agent<T, U, V> {
    public static final AttributeDescriptor<String> DEPLOYMENT_PATH = new AttributeDescriptor("deploymentPath", ValueType.TEXT);
    public static final AttributeDescriptor<HTTPMethod[]> ALLOWED_HTTP_METHODS = new AttributeDescriptor("allowedHTTPMethods", HTTPAgent.VALUE_HTTP_METHOD.asArray());
    public static final AttributeDescriptor<String[]> ALLOWED_ORIGINS = new AttributeDescriptor("allowedOrigins", ValueType.TEXT.asArray());
    public static final AttributeDescriptor<Boolean> ROLE_BASED_SECURITY = new AttributeDescriptor("roleBasedSecurity", ValueType.BOOLEAN);

    protected AbstractHTTPServerAgent() {
    }

    protected AbstractHTTPServerAgent(String name) {
        super(name);
    }

    public Optional<String> getDeploymentPath() {
        return this.getAttributes().getValue(DEPLOYMENT_PATH);
    }

    public T setDeploymentPath(String value) {
        this.getAttributes().getOrCreate(DEPLOYMENT_PATH).setValue((Object)value);
        return (T)((Object)this);
    }

    public Optional<HTTPMethod[]> getAllowedHTTPMethods() {
        return this.getAttributes().getValue(ALLOWED_HTTP_METHODS);
    }

    public T setAllowedHTTPMethods(HTTPMethod[] value) {
        this.getAttributes().getOrCreate(ALLOWED_HTTP_METHODS).setValue((Object)value);
        return (T)((Object)this);
    }

    public Optional<String[]> getAllowedOrigins() {
        return this.getAttributes().getValue(ALLOWED_ORIGINS);
    }

    public T setAllowedOrigins(String[] value) {
        this.getAttributes().getOrCreate(ALLOWED_ORIGINS).setValue((Object)value);
        return (T)((Object)this);
    }

    public Optional<Boolean> isRoleBasedSecurity() {
        return this.getAttributes().getValue(ROLE_BASED_SECURITY);
    }

    public T setRoleBasedSecurity(Boolean value) {
        this.getAttributes().getOrCreate(ROLE_BASED_SECURITY).setValue((Object)value);
        return (T)((Object)this);
    }
}

