/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.controller;

import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.openremote.agent.protocol.controller.ControllerCommand;
import org.openremote.agent.protocol.controller.command.ControllerCommandBasic;
import org.openremote.agent.protocol.controller.command.ControllerCommandMapped;
import org.openremote.agent.protocol.http.HTTPProtocol;
import org.openremote.model.attribute.AttributeEvent;

public class RequestBuilder {
    private static MultivaluedMap<String, Object> getDefaultHeaders() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.addAll((Object)"Accept", new Object[]{"application/json"});
        return headers;
    }

    public static HTTPProtocol.HttpClientRequest buildCommandRequest(ControllerCommand controllerCommand, AttributeEvent event, ResteasyWebTarget webTarget) {
        MultivaluedHashMap queryParam = new MultivaluedHashMap();
        if (controllerCommand instanceof ControllerCommandBasic) {
            String commandName = ((ControllerCommandBasic)controllerCommand).getCommandName();
            queryParam.add((Object)"name", (Object)commandName);
        } else {
            Map<String, String> actionCommandLink = ((ControllerCommandMapped)controllerCommand).getActionCommandLink();
            String attributeValue = event.getValue().map(Object::toString).orElse(null);
            String correspondingCommandName = actionCommandLink.get(attributeValue);
            queryParam.add((Object)"name", (Object)correspondingCommandName);
        }
        return new HTTPProtocol.HttpClientRequest((WebTarget)webTarget, "/rest/devices/" + controllerCommand.getDeviceName() + "/commands", "POST", RequestBuilder.getDefaultHeaders(), (MultivaluedMap<String, String>)queryParam, false, "application/json");
    }

    public static HTTPProtocol.HttpClientRequest buildStatusPollingRequest(String deviceName, List<String> sensorsName, String deviceId, ResteasyWebTarget webTarget) {
        MultivaluedHashMap queryParam = new MultivaluedHashMap();
        queryParam.addAll((Object)"name", sensorsName);
        return new HTTPProtocol.HttpClientRequest((WebTarget)webTarget, "/rest/devices/" + deviceName + "/polling/" + deviceId, "GET", RequestBuilder.getDefaultHeaders(), (MultivaluedMap<String, String>)queryParam, false, "application/json");
    }

    public static HTTPProtocol.HttpClientRequest buildStatusRequest(String deviceName, List<String> sensorsName, ResteasyWebTarget webTarget) {
        MultivaluedHashMap queryParam = new MultivaluedHashMap();
        queryParam.addAll((Object)"name", sensorsName);
        return new HTTPProtocol.HttpClientRequest((WebTarget)webTarget, "/rest/devices/" + deviceName + "/status", "GET", RequestBuilder.getDefaultHeaders(), (MultivaluedMap<String, String>)queryParam, false, "application/json");
    }

    public static HTTPProtocol.HttpClientRequest buildCheckRequest(ResteasyWebTarget webTarget) {
        return new HTTPProtocol.HttpClientRequest((WebTarget)webTarget, "", "GET", null, null, false, null);
    }
}

