/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.controller;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpHostConnectException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.controller.Controller;
import org.openremote.agent.protocol.controller.ControllerAgent;
import org.openremote.agent.protocol.controller.ControllerAgentLink;
import org.openremote.agent.protocol.controller.ControllerCommand;
import org.openremote.agent.protocol.controller.ControllerSensor;
import org.openremote.agent.protocol.controller.RequestBuilder;
import org.openremote.agent.protocol.controller.command.ControllerCommandBasic;
import org.openremote.agent.protocol.controller.command.ControllerCommandMapped;
import org.openremote.agent.protocol.http.HTTPProtocol;
import org.openremote.container.concurrent.GlobalLock;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueDescriptor;

public class ControllerProtocol
extends AbstractProtocol<ControllerAgent, ControllerAgentLink> {
    public static final int HEARTBEAT_DELAY_SECONDS = 5;
    public static final String PROTOCOL_DISPLAY_NAME = "Controller Client";
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, ControllerProtocol.class);
    private final Map<String, Future<?>> pollingSensorList = new HashMap();
    protected ResteasyClient client;
    private Controller controller;
    private ResteasyWebTarget controllerWebTarget;
    private ScheduledFuture<?> controllerHeartbeat;
    private final Map<AttributeRef, Boolean> initStatusDone = new HashMap<AttributeRef, Boolean>();

    public ControllerProtocol(ControllerAgent agent) {
        super(agent);
    }

    @Override
    public void doStart(Container container) throws Exception {
        URI uri;
        String baseURL = ((ControllerAgent)this.agent).getControllerURI().orElseThrow(() -> new IllegalArgumentException("Missing or invalid controller URI: " + this.agent));
        try {
            uri = new URIBuilder(baseURL).build();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.SEVERE, "Invalid Controller URI", e);
            this.setConnectionStatus(ConnectionStatus.ERROR);
            throw e;
        }
        this.client = WebTargetBuilder.createClient((ExecutorService)this.executorService, (int)10, (long)70000L, null);
        WebTargetBuilder webTargetBuilder = new WebTargetBuilder(this.client, uri);
        ((ControllerAgent)this.agent).getUsernamePassword().ifPresent(usernamePassword -> {
            LOG.info("Setting BASIC auth credentials for controller");
            webTargetBuilder.setBasicAuthentication(usernamePassword.getUsername(), usernamePassword.getPassword());
        });
        this.controllerWebTarget = webTargetBuilder.build();
        this.controller = new Controller(((ControllerAgent)this.agent).getId());
        this.controllerHeartbeat = this.executorService.scheduleWithFixedDelay(() -> this.executeHeartbeat(this::onHeartbeatResponse), 0L, 5L, TimeUnit.SECONDS);
    }

    @Override
    protected void setConnectionStatus(ConnectionStatus connectionStatus) {
        super.setConnectionStatus(connectionStatus);
        if (connectionStatus.equals((Object)ConnectionStatus.DISCONNECTED)) {
            for (Future<?> task : this.pollingSensorList.values()) {
                task.cancel(true);
            }
        }
    }

    @Override
    protected void doStop(Container container) throws Exception {
        if (this.controllerHeartbeat != null) {
            this.controllerHeartbeat.cancel(true);
        }
        this.pollingSensorList.values().forEach(pollingTask -> pollingTask.cancel(true));
        this.pollingSensorList.clear();
        this.initStatusDone.clear();
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, ControllerAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        String deviceName = agentLink.getDeviceName().orElse(null);
        String sensorName = agentLink.getSensorName().orElse(null);
        String commandDeviceName = agentLink.getCommandDeviceName().orElse(null);
        String commandName = agentLink.getCommandName().orElse(null);
        Map commandsMap = agentLink.getCommandsMap().orElse(null);
        if (sensorName != null) {
            LOG.finer("### Adding new sensor [" + deviceName + "," + sensorName + "] linked to " + ((ControllerAgent)this.agent).getId() + " (" + ((ControllerAgent)this.agent).getName() + ")");
            this.controller.addSensor(attributeRef, new ControllerSensor(deviceName, sensorName));
            if (this.pollingSensorList.containsKey(deviceName)) {
                this.pollingSensorList.get(deviceName).cancel(true);
            }
            this.initStatusDone.put(attributeRef, false);
            this.collectInitialStatus(attributeRef, deviceName, sensorName);
            this.schedulePollingTask(deviceName);
        }
        if (commandName != null || commandsMap != null) {
            if (commandDeviceName == null && deviceName != null) {
                commandDeviceName = deviceName;
            }
            if (commandName != null) {
                this.controller.addCommand(attributeRef, new ControllerCommandBasic(commandDeviceName, commandName));
            } else {
                assert (commandsMap.size() > 0);
                this.controller.addCommand(attributeRef, new ControllerCommandMapped(commandDeviceName, this.computeCommandsMapFromMultiValue(commandsMap)));
            }
        }
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, ControllerAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        this.controller.removeAttributeRef(attributeRef);
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, ControllerAgentLink agentLink, AttributeEvent event, Object processedValue) {
        LOG.finer("### Process Linked Attribute Write");
        AttributeRef attributeRef = event.getAttributeRef();
        ControllerCommand controllerCommand = this.controller.getCommand(attributeRef);
        HTTPProtocol.HttpClientRequest request = RequestBuilder.buildCommandRequest(controllerCommand, event, this.controllerWebTarget);
        String body = null;
        if (controllerCommand instanceof ControllerCommandBasic) {
            body = event.getValue().map(v -> {
                ObjectNode objectValue = ValueUtil.JSON.createObjectNode();
                objectValue.putPOJO("parameter", processedValue);
                return objectValue.toString();
            }).orElse(null);
        }
        this.executeAttributeWriteRequest(request, body, this::onAttributeWriteResponse);
    }

    private Map<String, String> computeCommandsMapFromMultiValue(Map<String, List<String>> multivaluedMap) {
        HashMap<String, String> commandsMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : multivaluedMap.entrySet()) {
            commandsMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return commandsMap;
    }

    private void collectInitialStatus(AttributeRef attributeRef, String deviceName, String sensorName) {
        this.executorService.submit(() -> this.executeInitialStatus(attributeRef, deviceName, sensorName, response -> this.onInitialStatusResponse(attributeRef, deviceName, sensorName, (Response)response)));
    }

    private void executeInitialStatus(AttributeRef attributeRef, String deviceName, String sensorName, Consumer<Response> responseConsumer) {
        GlobalLock.withLock((String)(this.getProtocolName() + "::executeInitialStatus::" + attributeRef), () -> {
            LOG.info("### Initial status check for " + attributeRef.getName() + " [" + deviceName + "," + sensorName + "] ...");
            HTTPProtocol.HttpClientRequest checkRequest = RequestBuilder.buildStatusRequest(deviceName, Arrays.asList(sensorName), this.controllerWebTarget);
            try (Response response = null;){
                response = checkRequest.invoke(null);
                responseConsumer.accept(response);
            }
        });
    }

    private void onInitialStatusResponse(AttributeRef attributeRef, String deviceName, String sensorName, Response response) {
        if (response != null) {
            if (response.getStatusInfo().equals(Response.Status.OK)) {
                LOG.finer("### New sensor [" + sensorName + "] status received");
                ArrayNode arrayValue = (ArrayNode)response.readEntity(ArrayNode.class);
                if (arrayValue.isEmpty()) {
                    LOG.warning("### Status response is empty");
                } else {
                    arrayValue.forEach(status -> {
                        String name = status.get("name").asText();
                        String value = status.get("value").asText();
                        this.updateAttributeValue(attributeRef, value);
                        this.initStatusDone.put(attributeRef, true);
                    });
                }
            } else {
                LOG.severe("### Status code for initial status received error : " + response.getStatus() + " --> " + response.getStatusInfo().getReasonPhrase());
            }
        } else {
            LOG.warning("### Initial status check return a null value for " + attributeRef.getName() + " [" + deviceName + "," + sensorName + "]");
        }
        if (!this.initStatusDone.get(attributeRef).booleanValue()) {
            this.collectInitialStatus(attributeRef, deviceName, sensorName);
        }
    }

    private Future<?> computePollingTask(String deviceName) {
        return (Future)GlobalLock.withLockReturning((String)(this.getProtocolName() + "::computePollingTask::" + deviceName), () -> {
            List<String> sensorNameList = this.controller.collectSensorNameLinkedToDeviceName(deviceName);
            if (sensorNameList.isEmpty()) {
                return null;
            }
            return this.executorService.submit(() -> this.executePollingRequest(deviceName, sensorNameList, response -> this.onPollingResponse(deviceName, sensorNameList, (Response)response)));
        });
    }

    private void executePollingRequest(String deviceName, List<String> sensorList, Consumer<Response> responseConsumer) {
        LOG.info("### Polling Request for device [device=" + deviceName + ", sensors=" + this.formatSensors(sensorList) + "]");
        HTTPProtocol.HttpClientRequest httpClientRequest = RequestBuilder.buildStatusPollingRequest(deviceName, sensorList, this.controller.getDeviceId(), this.controllerWebTarget);
        Response response = null;
        try {
            response = httpClientRequest.invoke(null);
            this.setConnectionStatus(ConnectionStatus.CONNECTED);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "### Exception thrown whilst doing polling request [device=" + deviceName + ", sensors=" + this.formatSensors(sensorList) + "]", e);
            this.checkIfConnectionRefused(e);
        }
        responseConsumer.accept(response);
    }

    private void onPollingResponse(String deviceName, List<String> sensorNameList, Response response) {
        if (response != null) {
            if (response.getStatusInfo() == Response.Status.OK) {
                String responseBodyAsString = (String)response.readEntity(String.class);
                LOG.info("### New sensors status received");
                LOG.finer("### Polling request body response : " + responseBodyAsString);
                ArrayNode statusArray = (ArrayNode)ValueUtil.convert((Object)responseBodyAsString, ArrayNode.class);
                if (statusArray == null) {
                    LOG.warning("### Polling response is not a JSON array or empty: " + responseBodyAsString);
                } else {
                    statusArray.forEach(status -> {
                        String name = Optional.ofNullable(status.get("name")).flatMap(ValueUtil::getString).orElse(null);
                        String value = Optional.ofNullable(status.get("value")).flatMap(ValueUtil::getString).orElse(null);
                        this.controller.getSensorsListForDevice(deviceName).stream().filter(entry -> ((ControllerSensor)entry.getValue()).getSensorName().equals(name)).forEach(e -> this.updateAttributeValue((AttributeRef)e.getKey(), value));
                    });
                }
            } else if (response.getStatusInfo() == Response.Status.REQUEST_TIMEOUT) {
                LOG.info("### Timeout from polling no changes on Controller side given sensors [device=" + deviceName + ", sensors=" + this.formatSensors(sensorNameList) + "]");
            } else {
                LOG.severe("### Status code received error : " + response.getStatus() + " --> " + response.getStatusInfo().getReasonPhrase());
            }
        } else {
            LOG.severe("### Received null response from polling (due to previous exception)");
        }
        this.schedulePollingTask(deviceName);
    }

    private void updateAttributeValue(AttributeRef attributeRef, String value) {
        LOG.finest("### Updating attribute " + attributeRef + " with value " + value);
        ValueDescriptor valueType = ((Attribute)this.linkedAttributes.get(attributeRef)).getType();
        Object valueObj = ValueUtil.convert((Object)value, (Class)valueType.getType());
        this.updateLinkedAttribute(new AttributeState(attributeRef, valueObj));
    }

    private void executeAttributeWriteRequest(HTTPProtocol.HttpClientRequest request, String body, Consumer<Response> responseConsumer) {
        Response response = null;
        try {
            response = request.invoke(body);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "### Exception thrown whilst doing attribute write request", e);
            this.checkIfConnectionRefused(e);
        }
        responseConsumer.accept(response);
    }

    private void onAttributeWriteResponse(Response response) {
        if (response != null) {
            LOG.finer("### Response from command (204 is a valid and success return) : " + response.getStatus());
            if (response.getStatus() != 204) {
                LOG.severe("### Linked attribute Write request return with an error (different from 204) : " + response.getStatusInfo().getReasonPhrase());
            }
        } else {
            LOG.warning("### Response set to null on Write");
        }
    }

    private String formatSensors(List<String> sensorList) {
        return String.join((CharSequence)",", sensorList);
    }

    private void checkIfConnectionRefused(Exception e) {
        HttpHostConnectException e2;
        if (e.getCause() instanceof HttpHostConnectException && ((e2 = (HttpHostConnectException)e.getCause()).getCause() instanceof ConnectException || e2.getCause() instanceof UnknownHostException)) {
            ConnectException e3 = (ConnectException)e2.getCause();
            LOG.log(Level.SEVERE, "Connection refused: " + e3.getMessage());
            this.setConnectionStatus(ConnectionStatus.DISCONNECTED);
            if (this.controllerHeartbeat == null || this.controllerHeartbeat.isCancelled()) {
                this.controllerHeartbeat = this.executorService.scheduleWithFixedDelay(() -> this.executeHeartbeat(this::onHeartbeatResponse), 0L, 5L, TimeUnit.SECONDS);
            }
        }
    }

    private void executeHeartbeat(Consumer<Response> responseConsumer) {
        GlobalLock.withLock((String)(this.getProtocolName() + "::executeHeartbeat"), () -> {
            LOG.info("Doing heartbeat check for controller: " + this.controllerWebTarget.getUriBuilder().build(new Object[0]));
            HTTPProtocol.HttpClientRequest checkRequest = RequestBuilder.buildCheckRequest(this.controllerWebTarget);
            try (Response response = null;){
                response = checkRequest.invoke(null);
                responseConsumer.accept(response);
            }
        });
    }

    private void onHeartbeatResponse(Response response) {
        if (response != null && (response.getStatusInfo().equals(Response.Status.OK) || response.getStatusInfo().equals(Response.Status.FOUND))) {
            LOG.info("Heartbeat check for controller success: " + this.controllerWebTarget.getUriBuilder().build(new Object[0]));
            this.setConnectionStatus(ConnectionStatus.CONNECTED);
            this.controllerHeartbeat.cancel(true);
            this.controllerHeartbeat = null;
        } else {
            String responseMsg = "NONE";
            if (response != null) {
                responseMsg = Integer.toString(response.getStatus());
            }
            LOG.severe("Heartbeat check for controller failed (Response = " + responseMsg + "): " + this.controllerWebTarget.getUriBuilder().build(new Object[0]));
        }
    }

    private void schedulePollingTask(String deviceName) {
        Future<?> scheduledFuture = this.computePollingTask(deviceName);
        if (scheduledFuture != null) {
            this.pollingSensorList.put(deviceName, scheduledFuture);
        }
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return "or-controller://" + (Serializable)(this.controllerWebTarget != null ? this.controllerWebTarget.getUriBuilder().build(new Object[0]) : ((ControllerAgent)this.agent).getId());
    }
}

