/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.controller;

import java.util.Optional;
import javax.persistence.Entity;
import org.openremote.agent.protocol.controller.ControllerAgentLink;
import org.openremote.agent.protocol.controller.ControllerProtocol;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.util.ModelIgnore;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueType;

@ModelIgnore
@Entity
public class ControllerAgent
extends Agent<ControllerAgent, ControllerProtocol, ControllerAgentLink> {
    public static final AttributeDescriptor<String> CONTROLLER_URI = new AttributeDescriptor("controllerURI", ValueType.TEXT);
    public static final AgentDescriptor<ControllerAgent, ControllerProtocol, ControllerAgentLink> DESCRIPTOR = new AgentDescriptor(ControllerAgent.class, ControllerProtocol.class, ControllerAgentLink.class);

    protected ControllerAgent() {
    }

    public ControllerAgent(String name) {
        super(name);
    }

    public ControllerProtocol getProtocolInstance() {
        return new ControllerProtocol(this);
    }

    public Optional<String> getControllerURI() {
        return this.getAttributes().getValue(CONTROLLER_URI);
    }

    public ControllerAgent setControllerURI(String uri) {
        this.getAttributes().getOrCreate(CONTROLLER_URI).setValue((Object)uri);
        return this;
    }
}

