/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openremote.agent.protocol.controller.ControllerCommand;
import org.openremote.agent.protocol.controller.ControllerSensor;
import org.openremote.container.concurrent.GlobalLock;
import org.openremote.model.attribute.AttributeRef;

public class Controller {
    public final String DEVICE_ID_BASE = "OR3ControllerProtocol";
    private String controllerConfigName;
    private String deviceId;
    private Map<AttributeRef, ControllerSensor> sensorsList = new HashMap<AttributeRef, ControllerSensor>();
    private Map<AttributeRef, ControllerCommand> commandsList = new HashMap<AttributeRef, ControllerCommand>();

    public Controller(String agentId) {
        this.controllerConfigName = agentId;
        this.deviceId = "OR3ControllerProtocol_" + agentId;
    }

    public void addSensor(AttributeRef attributeRef, ControllerSensor sensor) {
        this.sensorsList.put(attributeRef, sensor);
    }

    public void addCommand(AttributeRef attributeRef, ControllerCommand command) {
        this.commandsList.put(attributeRef, command);
    }

    public ControllerCommand getCommand(AttributeRef attributeRef) {
        return this.commandsList.get(attributeRef);
    }

    public Set<Map.Entry<AttributeRef, ControllerSensor>> getSensorsListForDevice(String deviceName) {
        return this.sensorsList.entrySet().stream().filter(entry -> ((ControllerSensor)entry.getValue()).getDeviceName().equals(deviceName)).collect(Collectors.toSet());
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getControllerConfigName() {
        return this.controllerConfigName;
    }

    public void removeAttributeRef(AttributeRef attributeRef) {
        GlobalLock.withLock((String)"Controller Client:Controller::removeAttributeRef", () -> {
            this.commandsList.remove(attributeRef);
            this.sensorsList.remove(attributeRef);
        });
    }

    public List<String> collectSensorNameLinkedToDeviceName(String deviceName) {
        return this.sensorsList.values().stream().filter(sensor -> sensor.getDeviceName().equals(deviceName)).map(ControllerSensor::getSensorName).distinct().collect(Collectors.toList());
    }
}

