/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

public class RelaySettings {
    public static final int RELAY_FEATURE_DISABLED = 0;
    public static final int RELAY_FEATURE_ENABLED = 1;
    public static final int RELAY_FEATURE_NOT_SUPPORTED = 2;
    private final int relayTransmitCount;
    private final int relayIntervalSteps;

    public RelaySettings(int relayTransmitCount, int relayIntervalSteps) {
        this.relayTransmitCount = relayTransmitCount;
        this.relayIntervalSteps = relayIntervalSteps;
    }

    public static boolean isRelaySupported(int relay) {
        switch (relay) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int getRelayTransmitCount() {
        return this.relayTransmitCount;
    }

    public int getTotalTransmissionsCount() {
        return this.relayTransmitCount + 1;
    }

    public int getRelayIntervalSteps() {
        return this.relayIntervalSteps;
    }

    public int getRetransmissionIntervals() {
        return (this.relayIntervalSteps + 1) * 10;
    }

    public static int decodeRelayRetransmitInterval(int interval) {
        if (interval >= 10 && interval <= 320 && interval % 10 != 0) {
            throw new IllegalArgumentException("Relay Retransmit Interval must be in range of 10-320 ms.");
        }
        return interval / 10 - 1;
    }
}

