/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openremote.agent.protocol.bluetooth.mesh.utils.AddressArray;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ProxyFilterType;

public class ProxyFilter {
    private final ProxyFilterType filterType;
    private final List<AddressArray> addresses = new ArrayList<AddressArray>();

    public ProxyFilter(ProxyFilterType filterType) {
        this.filterType = filterType;
    }

    public ProxyFilterType getFilterType() {
        return this.filterType;
    }

    public List<AddressArray> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void addAddress(AddressArray addressArray) {
        if (!this.contains(addressArray)) {
            this.addresses.add(addressArray);
        }
    }

    private boolean contains(AddressArray addressArray) {
        for (AddressArray arr : this.addresses) {
            if (!Arrays.equals(addressArray.getAddress(), arr.getAddress())) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(byte[] address) {
        if (MeshAddress.isValidUnicastAddress(address) || MeshAddress.isValidSubscriptionAddress(address)) {
            AddressArray addressArray = new AddressArray(address[0], address[1]);
            for (AddressArray arr : this.addresses) {
                if (!Arrays.equals(addressArray.getAddress(), arr.getAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAddress(AddressArray addressArray) {
        this.addresses.remove(addressArray);
    }
}

