/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;

public enum OutputOOBAction {
    NO_OUTPUT(0),
    BLINK(1),
    BEEP(2),
    VIBRATE(4),
    OUTPUT_NUMERIC(8),
    OUTPUT_ALPHA_NUMERIC(16);

    private static final Logger LOG;
    private short outputOOBAction;

    private OutputOOBAction(short outputOOBAction) {
        this.outputOOBAction = outputOOBAction;
    }

    public short getOutputOOBAction() {
        return this.outputOOBAction;
    }

    public static OutputOOBAction fromValue(short method) {
        switch (method) {
            default: {
                return NO_OUTPUT;
            }
            case 1: {
                return BLINK;
            }
            case 2: {
                return VIBRATE;
            }
            case 4: {
                return VIBRATE;
            }
            case 8: {
                return OUTPUT_NUMERIC;
            }
            case 16: 
        }
        return OUTPUT_ALPHA_NUMERIC;
    }

    public static String getOutputOOBActionDescription(OutputOOBAction type) {
        switch (type) {
            case NO_OUTPUT: {
                return "Not Supported";
            }
            case BLINK: {
                return "Blink";
            }
            case BEEP: {
                return "Beep";
            }
            case VIBRATE: {
                return "Vibrate";
            }
            case OUTPUT_NUMERIC: {
                return "Output Numeric";
            }
            case OUTPUT_ALPHA_NUMERIC: {
                return "Output Alpha Numeric";
            }
        }
        return "Unknown";
    }

    public static ArrayList<OutputOOBAction> parseOutputActionsFromBitMask(int outputAction) {
        OutputOOBAction[] outputActions = new OutputOOBAction[]{BLINK, BEEP, VIBRATE, OUTPUT_NUMERIC, OUTPUT_ALPHA_NUMERIC};
        ArrayList<OutputOOBAction> supportedActionValues = new ArrayList<OutputOOBAction>();
        for (OutputOOBAction action : outputActions) {
            if ((outputAction & action.outputOOBAction) != action.outputOOBAction) continue;
            supportedActionValues.add(action);
            LOG.info("Supported output oob action type: " + OutputOOBAction.getOutputOOBActionDescription(action));
        }
        return supportedActionValues;
    }

    public static int getOutputOOBActionValue(OutputOOBAction type) {
        switch (type) {
            case BLINK: {
                return 0;
            }
            case BEEP: {
                return 1;
            }
            case VIBRATE: {
                return 2;
            }
            case OUTPUT_NUMERIC: {
                return 3;
            }
            case OUTPUT_ALPHA_NUMERIC: {
                return 4;
            }
        }
        return 0;
    }

    public static int getOutputOOBActionValue(short actionType) {
        switch (OutputOOBAction.fromValue(actionType)) {
            case BLINK: {
                return 0;
            }
            case BEEP: {
                return 1;
            }
            case VIBRATE: {
                return 2;
            }
            case OUTPUT_NUMERIC: {
                return 3;
            }
            case OUTPUT_ALPHA_NUMERIC: {
                return 4;
            }
        }
        return 0;
    }

    public static byte[] generateOutputOOBAuthenticationValue(OutputOOBAction outputActionType, String input) {
        int authLength = 16;
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        switch (outputActionType) {
            case BLINK: 
            case BEEP: 
            case VIBRATE: 
            case OUTPUT_NUMERIC: {
                buffer.position(8);
                long intValue = Long.valueOf(input);
                buffer.putLong(intValue);
                return buffer.array();
            }
            case OUTPUT_ALPHA_NUMERIC: {
                buffer.put(input.toUpperCase(Locale.US).getBytes());
                return buffer.array();
            }
        }
        return null;
    }

    static {
        LOG = Logger.getLogger(OutputOOBAction.class.getName());
    }
}

