/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

public class NetworkTransmitSettings {
    private final int networkTransmitCount;
    private final int networkIntervalSteps;

    public NetworkTransmitSettings(int networkTransmitCount, int networkIntervalSteps) {
        if (networkTransmitCount < 1 || networkTransmitCount > 8) {
            throw new IllegalArgumentException("Network Transmit count must be in range 1-8.");
        }
        this.networkTransmitCount = networkTransmitCount;
        this.networkIntervalSteps = networkIntervalSteps;
    }

    public int getNetworkTransmitCount() {
        return this.networkTransmitCount;
    }

    public int getTransmissionCount() {
        return this.networkTransmitCount + 1;
    }

    public int getNetworkIntervalSteps() {
        return this.networkIntervalSteps;
    }

    public int getNetworkTransmissionInterval() {
        return (this.networkIntervalSteps + 1) * 10;
    }

    public static int decodeNetworkTransmissionInterval(int interval) {
        if (interval >= 10 && interval <= 320 && interval % 10 != 0) {
            throw new IllegalArgumentException("Network Transmission Interval must be 10-320 ms with a step of 10 ms");
        }
        return interval / 10 - 1;
    }
}

