/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

import org.openremote.agent.protocol.bluetooth.mesh.utils.Heartbeat;

public class HeartbeatSubscription
extends Heartbeat {
    private final int src;
    private int minHops;
    private int maxHops;

    public HeartbeatSubscription(int src, int dst, byte periodLog, byte countLog, int minHops, int maxHops) {
        super(dst, periodLog, countLog);
        this.src = src;
        this.minHops = minHops;
        this.maxHops = maxHops;
    }

    public String toString() {
        return "Source address: " + Integer.toHexString(this.src) + "\nDestination address: " + Integer.toHexString(this.dst) + "\nPeriod Log: " + Integer.toHexString(this.periodLog) + "\nCount Log: " + Integer.toHexString(this.countLog) + "\nMin Hops: " + this.minHops + "\n Max Hops: " + this.maxHops;
    }

    public int getSrc() {
        return this.src;
    }

    public int getMinHops() {
        return this.minHops;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    @Override
    public boolean isEnabled() {
        return this.src != 0 && this.dst != 0;
    }

    public String getCountLogDescription() {
        if (this.countLog == 0 || this.countLog == 1) {
            return String.valueOf(this.countLog);
        }
        if (this.countLog >= 2 && this.countLog <= 16) {
            int lowerBound = (int)Math.pow(2.0, this.countLog - 1);
            int upperBound = Math.min(65534, (int)Math.pow(2.0, this.countLog) - 1);
            return lowerBound + " ... " + upperBound;
        }
        return "More than 65534";
    }

    public String getPeriodLogDescription() {
        if (this.periodLog == 0) {
            return "Disabled";
        }
        if (this.periodLog == 1) {
            return "1";
        }
        if (this.periodLog >= 2 && this.periodLog < 17) {
            int lowerBound = (int)Math.pow(2.0, this.periodLog - 1);
            int upperBound = (int)(Math.pow(2.0, this.periodLog) - 1.0);
            return HeartbeatSubscription.periodToTime(lowerBound) + " ... " + HeartbeatSubscription.periodToTime(upperBound);
        }
        if (this.periodLog == 17) {
            return "65535";
        }
        return "Invalid";
    }

    public Short getPeriodLog2Period() {
        if (this.periodLog == 0) {
            return (short)0;
        }
        if (this.periodLog >= 1 && this.periodLog <= 16) {
            return (short)Math.pow(2.0, this.periodLog - 1);
        }
        if (this.periodLog == 17) {
            return (short)-1;
        }
        throw new IllegalArgumentException("Period Log out of range");
    }
}

