/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

import org.openremote.agent.protocol.bluetooth.mesh.Features;
import org.openremote.agent.protocol.bluetooth.mesh.utils.Heartbeat;

public class HeartbeatPublication
extends Heartbeat {
    private final int ttl;
    private final Features features;
    private final int netKeyIndex;

    public HeartbeatPublication(int dst, byte countLog, byte periodLog, int ttl, Features features, int netKeyIndex) {
        super(dst, periodLog, countLog);
        this.ttl = ttl;
        this.features = features;
        this.netKeyIndex = netKeyIndex;
    }

    public String toString() {
        return "Destination address: " + Integer.toHexString(this.dst) + "\nCount Log: " + Integer.toHexString(this.countLog) + "\nPeriod Log: " + Integer.toHexString(this.periodLog) + "\nTTL: " + this.ttl + "\nFeatures: " + this.features == null ? "null" : this.features.toString() + "\nNet key index: " + Integer.toHexString(this.netKeyIndex);
    }

    public int getPeriod() {
        return HeartbeatPublication.calculateHeartbeatPeriod(this.periodLog);
    }

    public int getTtl() {
        return this.ttl;
    }

    public Features getFeatures() {
        return this.features;
    }

    public int getNetKeyIndex() {
        return this.netKeyIndex;
    }

    @Override
    public boolean isEnabled() {
        return this.dst != 0;
    }

    public String getPeriodLogDescription() {
        if (this.periodLog == 0) {
            return "Disabled";
        }
        if (this.periodLog >= 1 || this.periodLog <= 17) {
            return (int)Math.pow(2.0, this.periodLog - 1) + " s";
        }
        return "Prohibited";
    }

    public Short getPeriodLog2Period(int periodLog) {
        if (periodLog == 0) {
            return (short)0;
        }
        if (periodLog >= 1 && periodLog <= 16) {
            return (short)Math.pow(2.0, periodLog - 1);
        }
        return (short)-1;
    }

    public String getCountLogDescription() {
        if (this.countLog == 0) {
            return "Disabled";
        }
        if (this.countLog == 255) {
            return "Indefinite";
        }
        if (this.countLog == 1 || this.countLog == 2) {
            return String.valueOf(this.countLog);
        }
        if (this.countLog == 17) {
            return "0x8001 ... 0xFFFE";
        }
        if (this.countLog >= 3 && this.countLog <= 16) {
            int lowerBound = (int)Math.pow(2.0, this.countLog - 2) + 1;
            int upperBound = (int)Math.pow(2.0, this.countLog - 1);
            return lowerBound + " ... " + upperBound;
        }
        return "Invalid";
    }
}

