/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

public abstract class Heartbeat {
    public static final int DO_NOT_SEND_PERIODICALLY = 0;
    public static final int PERIOD_MIN = 0;
    public static final int PERIOD_MAX = 65536;
    public static final int PERIOD_LOG_MIN = 1;
    public static final int PERIOD_LOG_MAX = 17;
    public static final int COUNT_MIN = 0;
    public static final int COUNT_MAX = 17;
    public static final int SEND_INDEFINITELY = 255;
    public static final int DEFAULT_PUBLICATION_TTL = 5;
    protected int dst;
    protected byte periodLog;
    protected byte countLog;

    Heartbeat(int dst, byte periodLog, byte countLog) {
        this.dst = dst;
        this.periodLog = periodLog;
        this.countLog = countLog;
    }

    public abstract boolean isEnabled();

    public int getDst() {
        return this.dst;
    }

    public byte getPeriodLog() {
        return this.periodLog;
    }

    public static int calculateHeartbeatPeriod(short periodLog) {
        return (int)Math.pow(2.0, periodLog - 1);
    }

    public static byte decodeHeartbeatPeriod(int period) {
        switch (period) {
            case 0: {
                return 0;
            }
            case 65535: {
                return 17;
            }
        }
        return Heartbeat.log2(period);
    }

    private static byte log2(int period) {
        return (byte)(Math.log(period) / Math.log(2.0) + 1.0);
    }

    public static boolean isValidHeartbeatPeriod(int period) {
        if (period >= 0 && period < 65535) {
            return true;
        }
        throw new IllegalArgumentException("Period must be within the range of 0x0000 to 0xFFFF!");
    }

    public static boolean isValidHeartbeatPeriodLog(byte period) {
        if (period >= 0 && period < 17) {
            return true;
        }
        throw new IllegalArgumentException("Period log must be within the range of 0x00 to 0x11!");
    }

    public byte getCountLog() {
        return this.countLog;
    }

    public static int calculateHeartbeatCount(int countLog) {
        if (countLog > 17 && countLog < 255) {
            throw new IllegalArgumentException("Prohibited, count log must be a value from 0x00 to 0x11 and 0xFF");
        }
        if (countLog == 17) {
            return (int)Math.pow(2.0, countLog - 1) - 2;
        }
        return (int)Math.pow(2.0, countLog - 1);
    }

    public static String periodToTime(int seconds) {
        if (seconds == 1) {
            return seconds + " second";
        }
        if (seconds > 1 && seconds < 60) {
            return seconds + " seconds";
        }
        if (seconds >= 60 && seconds < 3600) {
            return seconds / 60 + " min " + seconds % 60 + " sec";
        }
        if (seconds >= 3600 && seconds <= 65535) {
            return seconds / 3600 + " h " + seconds % 3600 / 60 + " min " + seconds % 3600 % 60 + " sec";
        }
        return seconds / 3600 + " h " + seconds % 3600 / 60 + " min " + (seconds % 3600 % 60 - 1) + " sec";
    }
}

