/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.utils;

import java.util.ArrayList;
import java.util.logging.Logger;

public enum AlgorithmType {
    NONE(0),
    FIPS_P_256_ELLIPTIC_CURVE(1);

    private static final Logger LOG;
    private short algorithmType;

    private AlgorithmType(short algorithmType) {
        this.algorithmType = algorithmType;
    }

    public short getAlgorithmType() {
        return this.algorithmType;
    }

    public static AlgorithmType fromValue(short method) {
        switch (method) {
            default: {
                return NONE;
            }
            case 1: 
        }
        return FIPS_P_256_ELLIPTIC_CURVE;
    }

    public static ArrayList<AlgorithmType> getAlgorithmTypeFromBitMask(short algorithmTypeValue) {
        AlgorithmType[] algorithmTypes = new AlgorithmType[]{FIPS_P_256_ELLIPTIC_CURVE};
        ArrayList<AlgorithmType> supportedAlgorithms = new ArrayList<AlgorithmType>();
        for (AlgorithmType algorithmType : algorithmTypes) {
            if ((algorithmTypeValue & algorithmType.ordinal()) != algorithmType.ordinal()) continue;
            supportedAlgorithms.add(algorithmType);
            LOG.info("Supported output oob action type: " + AlgorithmType.getAlgorithmTypeDescription(algorithmType));
        }
        return supportedAlgorithms;
    }

    public static String getAlgorithmTypeDescription(AlgorithmType type) {
        switch (type) {
            case FIPS_P_256_ELLIPTIC_CURVE: {
                return "FIPS P-256 Elliptic Curve";
            }
        }
        return "Unknown";
    }

    public static byte getAlgorithmValue(short type) {
        switch (AlgorithmType.fromValue(type)) {
            case FIPS_P_256_ELLIPTIC_CURVE: {
                return 0;
            }
        }
        return 1;
    }

    static {
        LOG = Logger.getLogger(AlgorithmType.class.getName());
    }
}

