/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class VendorModelMessageStatus
extends GenericStatusMessage {
    public static final Logger LOG = Logger.getLogger(VendorModelMessageStatus.class.getName());
    private final int mModelIdentifier;

    public VendorModelMessageStatus(AccessMessage message, int modelIdentifier) {
        super(message);
        this.mParameters = message.getParameters();
        this.mModelIdentifier = modelIdentifier;
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received Vendor model status: " + MeshParserUtils.bytesToHex(this.mParameters, false));
    }

    @Override
    public int getOpCode() {
        return this.mMessage.getOpCode();
    }

    public final byte[] getAccessPayload() {
        return ((AccessMessage)this.mMessage).getAccessPdu();
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }
}

