/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.UUID;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.InternalMeshMsgHandlerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshTransport;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageAcked;

class VendorModelMessageAckedState
extends GenericMessageState {
    public static final Logger LOG = Logger.getLogger(VendorModelMessageAckedState.class.getName());

    VendorModelMessageAckedState(int src, int dst, VendorModelMessageAcked vendorModelMessageAcked, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, vendorModelMessageAcked, meshTransport, callbacks);
    }

    VendorModelMessageAckedState(int src, int dst, UUID label, VendorModelMessageAcked vendorModelMessageAcked, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(src, dst, label, vendorModelMessageAcked, meshTransport, callbacks);
    }

    @Override
    public synchronized MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.VENDOR_MODEL_ACKNOWLEDGED_STATE;
    }

    @Override
    protected final synchronized void createAccessMessage() {
        VendorModelMessageAcked message = (VendorModelMessageAcked)this.mMeshMessage;
        ApplicationKey key = message.getAppKey();
        int akf = message.getAkf();
        int aid = message.getAid();
        int aszmic = message.getAszmic();
        int opCode = message.getOpCode();
        byte[] parameters = message.getParameters();
        int companyIdentifier = message.getCompanyIdentifier();
        this.message = this.mMeshTransport.createVendorMeshMessage(companyIdentifier, this.mSrc, this.mDst, this.mLabel, message.messageTtl, key, akf, aid, aszmic, opCode, parameters);
        message.setMessage(this.message);
    }

    @Override
    public synchronized void executeSend() {
        LOG.info("Sending acknowledged vendor model message");
        super.executeSend();
    }
}

