/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class VendorModelMessageAcked
extends GenericMessage {
    public static final Logger LOG = Logger.getLogger(VendorModelMessageAcked.class.getName());
    private static final int VENDOR_MODEL_OPCODE_LENGTH = 4;
    private final int mModelIdentifier;
    private final int mCompanyIdentifier;
    private final int mOpCode;

    public VendorModelMessageAcked(ApplicationKey appKey, int modelId, int companyIdentifier, int opCode, byte[] parameters) {
        super(appKey);
        this.mModelIdentifier = modelId;
        this.mCompanyIdentifier = companyIdentifier;
        this.mOpCode = opCode;
        this.mParameters = parameters;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return this.mOpCode;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
    }

    public final int getCompanyIdentifier() {
        return this.mCompanyIdentifier;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }
}

