/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.Group;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessLayer;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.transport.UpperTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ExtendedInvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public abstract class UpperTransportLayer
extends AccessLayer {
    public static final Logger LOG = Logger.getLogger(UpperTransportLayer.class.getName());
    private static final int PROXY_CONFIG_OPCODE_LENGTH = 1;
    static final int MAX_SEGMENTED_ACCESS_PAYLOAD_LENGTH = 12;
    public static final int MAX_UNSEGMENTED_CONTROL_PAYLOAD_LENGTH = 11;
    public static final int MAX_SEGMENTED_CONTROL_PAYLOAD_LENGTH = 8;
    public static final int NONCE_TYPE_NETWORK = 0;
    public static final int NONCE_TYPE_PROXY = 3;
    public static final int PAD_NETWORK_NONCE = 0;
    public static final int PAD_PROXY_NONCE = 0;
    public static final int APPLICATION_KEY_IDENTIFIER = 0;
    private static final int MAX_UNSEGMENTED_ACCESS_PAYLOAD_LENGTH = 15;
    private static final int NONCE_TYPE_APPLICATION = 1;
    private static final int NONCE_TYPE_DEVICE = 2;
    private static final int PAD_APPLICATION_DEVICE_NONCE = 0;
    private static final int SZMIC = 1;
    private static final int TRANSPORT_SAR_SEQZERO_MASK = 8191;
    private static final int DEFAULT_UNSEGMENTED_MIC_LENGTH = 4;
    private static final int MINIMUM_TRANSMIC_LENGTH = 4;
    private static final int MAXIMUM_TRANSMIC_LENGTH = 8;
    UpperTransportLayerCallbacks mUpperTransportLayerCallbacks;

    abstract void createLowerTransportAccessPDU(AccessMessage var1);

    abstract void createLowerTransportControlPDU(ControlMessage var1);

    abstract void reassembleLowerTransportAccessPDU(AccessMessage var1);

    abstract void reassembleLowerTransportControlPDU(ControlMessage var1);

    abstract void setUpperTransportLayerCallbacks(UpperTransportLayerCallbacks var1);

    @Override
    synchronized void createMeshMessage(Message message) {
        if (message instanceof AccessMessage) {
            super.createMeshMessage(message);
            AccessMessage accessMessage = (AccessMessage)message;
            byte[] encryptedTransportPDU = this.encryptUpperTransportPDU(accessMessage);
            LOG.info("Encrypted upper transport pdu: " + MeshParserUtils.bytesToHex(encryptedTransportPDU, false));
            accessMessage.setUpperTransportPdu(encryptedTransportPDU);
        } else {
            this.createUpperTransportPDU(message);
        }
    }

    @Override
    synchronized void createVendorMeshMessage(Message message) {
        super.createVendorMeshMessage(message);
        AccessMessage accessMessage = (AccessMessage)message;
        byte[] encryptedTransportPDU = this.encryptUpperTransportPDU(accessMessage);
        LOG.info("Encrypted upper transport pdu: " + MeshParserUtils.bytesToHex(encryptedTransportPDU, false));
        accessMessage.setUpperTransportPdu(encryptedTransportPDU);
    }

    synchronized void createUpperTransportPDU(Message message) {
        if (message instanceof AccessMessage) {
            AccessMessage accessMessage = (AccessMessage)message;
            byte[] encryptedTransportPDU = this.encryptUpperTransportPDU(accessMessage);
            LOG.info("Encrypted upper transport pdu: " + MeshParserUtils.bytesToHex(encryptedTransportPDU, false));
            accessMessage.setUpperTransportPdu(encryptedTransportPDU);
        } else {
            ByteBuffer accessMessageBuffer;
            ControlMessage controlMessage = (ControlMessage)message;
            int opCode = controlMessage.getOpCode();
            byte[] parameters = controlMessage.getParameters();
            if (parameters != null) {
                accessMessageBuffer = ByteBuffer.allocate(1 + parameters.length).order(ByteOrder.BIG_ENDIAN).put((byte)opCode).put(parameters);
            } else {
                accessMessageBuffer = ByteBuffer.allocate(1);
                accessMessageBuffer.put((byte)opCode);
            }
            byte[] accessPdu = accessMessageBuffer.array();
            LOG.info("Created Transport Control PDU " + MeshParserUtils.bytesToHex(accessPdu, false));
            controlMessage.setTransportControlPdu(accessPdu);
        }
    }

    final synchronized void parseUpperTransportPDU(Message message) throws ExtendedInvalidCipherTextException {
        try {
            switch (message.getPduType()) {
                case 0: {
                    if (!(message instanceof AccessMessage)) break;
                    AccessMessage accessMessage = (AccessMessage)message;
                    this.reassembleLowerTransportAccessPDU(accessMessage);
                    byte[] decryptedUpperTransportControlPdu = this.decryptUpperTransportPDU(accessMessage);
                    accessMessage.setAccessPdu(decryptedUpperTransportControlPdu);
                    break;
                }
                case 2: {
                    ControlMessage controlMessage = (ControlMessage)message;
                    if (controlMessage.getLowerTransportControlPdu().size() != 1) break;
                    byte[] lowerTransportControlPdu = controlMessage.getLowerTransportControlPdu().get(0);
                    ByteBuffer buffer = ByteBuffer.wrap(lowerTransportControlPdu).order(ByteOrder.BIG_ENDIAN);
                    message.setOpCode(buffer.get());
                    byte[] parameters = new byte[buffer.capacity() - 1];
                    buffer.get(parameters);
                    message.setParameters(parameters);
                }
            }
        }
        catch (InvalidCipherTextException ex) {
            throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), UpperTransportLayer.class.getSimpleName());
        }
    }

    private byte[] encryptUpperTransportPDU(AccessMessage message) {
        byte[] nonce;
        byte[] key;
        byte[] accessPDU = message.getAccessPdu();
        int akf = message.getAkf();
        int aszmic = message.getAszmic();
        byte[] sequenceNumber = message.getSequenceNumber();
        int src = message.getSrc();
        int dst = message.getDst();
        byte[] ivIndex = message.getIvIndex();
        if (akf == 0) {
            key = message.getDeviceKey();
            nonce = this.createDeviceNonce(aszmic, sequenceNumber, src, dst, ivIndex);
            LOG.info("Device nonce: " + MeshParserUtils.bytesToHex(nonce, false));
        } else {
            key = message.getApplicationKey().getKey();
            nonce = this.createApplicationNonce(aszmic, sequenceNumber, src, dst, ivIndex);
            LOG.info("Application nonce: " + MeshParserUtils.bytesToHex(nonce, false));
        }
        int encryptedPduLength = accessPDU.length + 4;
        int transMicLength = encryptedPduLength <= 15 ? SecureUtils.getTransMicLength(message.getCtl()) : SecureUtils.getTransMicLength(message.getAszmic());
        if (MeshAddress.isValidVirtualAddress(dst)) {
            return SecureUtils.encryptCCM(accessPDU, key, nonce, MeshParserUtils.uuidToBytes(message.getLabel()), transMicLength);
        }
        return SecureUtils.encryptCCM(accessPDU, key, nonce, transMicLength);
    }

    private byte[] decryptUpperTransportPDU(AccessMessage accessMessage) throws InvalidCipherTextException {
        byte[] decryptedUpperTransportPDU;
        int transportMicLength;
        int n = transportMicLength = accessMessage.getAszmic() == 1 ? 8 : 4;
        if (0 == accessMessage.getAkf()) {
            byte[] key = this.mMeshNode.getDeviceKey();
            byte[] nonce = this.createDeviceNonce(accessMessage.getAszmic(), accessMessage.getSequenceNumber(), accessMessage.getSrc(), accessMessage.getDst(), accessMessage.getIvIndex());
            decryptedUpperTransportPDU = SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key, nonce, transportMicLength);
        } else {
            List<ApplicationKey> keys = this.mUpperTransportLayerCallbacks.getApplicationKeys(accessMessage.getNetworkKey().getKeyIndex());
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Unable to find the app key to decrypt the message");
            }
            byte[] nonce = this.createApplicationNonce(accessMessage.getAszmic(), accessMessage.getSequenceNumber(), accessMessage.getSrc(), accessMessage.getDst(), accessMessage.getIvIndex());
            decryptedUpperTransportPDU = MeshAddress.isValidVirtualAddress(accessMessage.getDst()) ? this.decrypt(accessMessage, this.mUpperTransportLayerCallbacks.gerVirtualGroups(), keys, nonce, transportMicLength) : this.decrypt(accessMessage, keys, nonce, transportMicLength);
        }
        if (decryptedUpperTransportPDU == null) {
            throw new IllegalArgumentException("Unable to decrypt the message, invalid application key identifier!");
        }
        byte[] tempBytes = new byte[decryptedUpperTransportPDU.length];
        ByteBuffer decryptedBuffer = ByteBuffer.wrap(tempBytes);
        decryptedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        decryptedBuffer.put(decryptedUpperTransportPDU);
        decryptedUpperTransportPDU = decryptedBuffer.array();
        return decryptedUpperTransportPDU;
    }

    private byte[] decrypt(AccessMessage accessMessage, List<Group> groups, List<ApplicationKey> keys, byte[] nonce, int transportMicLength) {
        for (ApplicationKey key : keys) {
            for (Group group : groups) {
                if (group.getAddressLabel() == null) continue;
                if (key.getAid() == accessMessage.getAid()) {
                    try {
                        return SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key.getKey(), nonce, MeshParserUtils.uuidToBytes(group.getAddressLabel()), transportMicLength);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (key.getOldAid() != accessMessage.getAid()) continue;
                try {
                    return SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key.getOldKey(), nonce, MeshParserUtils.uuidToBytes(group.getAddressLabel()), transportMicLength);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private byte[] decrypt(AccessMessage accessMessage, List<ApplicationKey> keys, byte[] nonce, int transportMicLength) {
        for (ApplicationKey key : keys) {
            if (key.getAid() == accessMessage.getAid()) {
                try {
                    return SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key.getKey(), nonce, transportMicLength);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (key.getOldAid() != accessMessage.getAid()) continue;
            try {
                return SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key.getKey(), nonce, transportMicLength);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private byte[] createApplicationNonce(int aszmic, byte[] sequenceNumber, int src, int dst, byte[] ivIndex) {
        ByteBuffer applicationNonceBuffer = ByteBuffer.allocate(13);
        applicationNonceBuffer.put((byte)1);
        applicationNonceBuffer.put((byte)(aszmic << 7 | 0));
        applicationNonceBuffer.put(sequenceNumber);
        applicationNonceBuffer.putShort((short)src);
        applicationNonceBuffer.putShort((short)dst);
        applicationNonceBuffer.put(ivIndex);
        return applicationNonceBuffer.array();
    }

    private byte[] createDeviceNonce(int aszmic, byte[] sequenceNumber, int src, int dst, byte[] ivIndex) {
        ByteBuffer deviceNonceBuffer = ByteBuffer.allocate(13);
        deviceNonceBuffer.put((byte)2);
        deviceNonceBuffer.put((byte)(aszmic << 7 | 0));
        deviceNonceBuffer.put(sequenceNumber);
        deviceNonceBuffer.putShort((short)src);
        deviceNonceBuffer.putShort((short)dst);
        deviceNonceBuffer.put(ivIndex);
        return deviceNonceBuffer.array();
    }

    final int getTransportLayerSequenceNumber(int networkLayerSequenceNumber, int seqZero) {
        if ((networkLayerSequenceNumber & 0x1FFF) < seqZero) {
            return networkLayerSequenceNumber - ((networkLayerSequenceNumber & 0x1FFF) - seqZero) - 8192;
        }
        return networkLayerSequenceNumber - ((networkLayerSequenceNumber & 0x1FFF) - seqZero);
    }
}

