/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.Scene;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class SceneStore
extends GenericMessage {
    public static final Logger LOG = Logger.getLogger(SceneStore.class.getName());
    private static final int OP_CODE = 33350;
    private static final int SCENE_STORE_PARAMS_LENGTH = 2;
    private int mSceneNumber;

    public SceneStore(ApplicationKey appKey, int sceneNumber) {
        super(appKey);
        if (Scene.isValidSceneNumber(sceneNumber)) {
            this.mSceneNumber = sceneNumber;
        }
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33350;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        LOG.info("Scene Number: " + this.mSceneNumber);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.mSceneNumber);
        this.mParameters = paramsBuffer.array();
    }
}

