/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneStatuses;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class SceneStatus
extends GenericStatusMessage
implements SceneStatuses {
    private static final int SCENE_STATUS_MANDATORY_LENGTH = 3;
    private static final String TAG = SceneStatus.class.getSimpleName();
    private static final int OP_CODE = 94;
    private int mStatusCode;
    private int mCurrentScene;
    private int mTargetScene;
    private int mRemainingTime;
    private int mTransitionSteps;
    private int mTransitionResolution;
    public static final Logger LOG = Logger.getLogger(SceneStatus.class.getName());

    public SceneStatus(AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received scene status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mStatusCode = buffer.get() & 0xFF;
        this.mCurrentScene = buffer.getShort() & 0xFFFF;
        LOG.info("Status: " + this.mStatusCode);
        LOG.info("Current Scene : " + this.mCurrentScene);
        if (buffer.limit() > 3) {
            this.mTargetScene = buffer.getShort() & 0xFFFF;
            this.mRemainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = this.mRemainingTime & 0x3F;
            this.mTransitionResolution = this.mRemainingTime >> 6;
            LOG.info("Target scene: " + this.mTargetScene);
            LOG.info("Remaining time, transition number of steps: " + this.mTransitionSteps);
            LOG.info("Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            LOG.info("Remaining time: " + MeshParserUtils.getRemainingTime(this.mRemainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 94;
    }

    public final int getStatus() {
        return this.mStatusCode;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public final int getCurrentScene() {
        return this.mCurrentScene;
    }

    public final Integer getTargetScene() {
        return this.mTargetScene;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }
}

