/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneStatuses;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public final class SceneRegisterStatus
extends GenericStatusMessage
implements SceneStatuses {
    private static final int SCENE_REGISTER_STATUS_MANDATORY_LENGTH = 3;
    public static final Logger LOG = Logger.getLogger(SceneRegisterStatus.class.getName());
    private static final int OP_CODE = 33349;
    private int mStatus;
    private int mCurrentScene;
    private final ArrayList<Integer> mSceneList = new ArrayList();

    public SceneRegisterStatus(AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received scene register status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mStatus = buffer.get() & 0xFF;
        this.mCurrentScene = buffer.getShort() & 0xFFFF;
        LOG.info("Status: " + this.mStatus);
        LOG.info("Current Scene: " + this.mCurrentScene);
        if (buffer.limit() > 3) {
            int sceneCount = (buffer.limit() - 3) / 2;
            for (int i = 0; i < sceneCount; ++i) {
                this.mSceneList.add(buffer.getShort() & 0xFFFF);
            }
            LOG.info("Scenes stored: " + sceneCount);
        }
    }

    @Override
    public int getOpCode() {
        return 33349;
    }

    public final int getStatus() {
        return this.mStatus;
    }

    public boolean isSuccessful() {
        return this.mStatus == 0;
    }

    public final int getCurrentScene() {
        return this.mCurrentScene;
    }

    public ArrayList<Integer> getSceneList() {
        return this.mSceneList;
    }
}

