/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class SceneRecall
extends GenericMessage {
    public static final Logger LOG = Logger.getLogger(SceneRecall.class.getName());
    private static final int OP_CODE = 33346;
    private static final int SCENE_RECALL_TRANSITION_PARAMS_LENGTH = 5;
    private static final int SCENE_RECALL_PARAMS_LENGTH = 3;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int mSceneNumber;
    private final int tId;

    public SceneRecall(ApplicationKey appKey, int sceneNumber, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, sceneNumber, tId);
    }

    public SceneRecall(ApplicationKey appKey, Integer transitionSteps, Integer transitionResolution, Integer delay, int sceneNumber, int tId) {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.mSceneNumber = sceneNumber;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33346;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        LOG.info("Scene number: " + this.mSceneNumber);
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mSceneNumber);
            paramsBuffer.put((byte)this.tId);
        } else {
            LOG.info("Transition steps: " + this.mTransitionSteps);
            LOG.info("Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mSceneNumber);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

