/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.Scene;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class SceneDelete
extends GenericMessage {
    public static final Logger LOG = Logger.getLogger(SceneDelete.class.getName());
    private static final int OP_CODE = 33438;
    private static final int SCENE_DELETE_PARAMS_LENGTH = 2;
    private int sceneNumber;

    public SceneDelete(ApplicationKey appKey, int sceneNumber) {
        super(appKey);
        if (Scene.isValidSceneNumber(sceneNumber)) {
            this.sceneNumber = sceneNumber;
        }
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33438;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        LOG.info("Scene Number: " + this.sceneNumber);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.sceneNumber);
        this.mParameters = paramsBuffer.array();
    }

    public int getSceneNumber() {
        return this.sceneNumber;
    }
}

