/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.AddressArray;

public class ProxyConfigRemoveAddressFromFilter
extends ProxyConfigMessage {
    private final List<AddressArray> addresses = new ArrayList<AddressArray>();

    public ProxyConfigRemoveAddressFromFilter(List<AddressArray> addresses) throws IllegalArgumentException {
        this.addresses.addAll(addresses);
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() throws IllegalArgumentException {
        if (this.addresses.isEmpty()) {
            throw new IllegalArgumentException("Address list cannot be empty!");
        }
        int length = (int)Math.pow(2.0, this.addresses.size());
        this.mParameters = new byte[length];
        int count = 0;
        for (AddressArray addressArray : this.addresses) {
            this.mParameters[count] = addressArray.getAddress()[0];
            this.mParameters[count + 1] = addressArray.getAddress()[1];
            count += 2;
        }
    }

    @Override
    public int getOpCode() {
        return 2;
    }

    @Override
    byte[] getParameters() {
        return this.mParameters;
    }

    public List<AddressArray> getAddresses() {
        return this.addresses;
    }
}

