/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ProxyFilterType;

public class ProxyConfigFilterStatus
extends ProxyConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ProxyConfigFilterStatus.class.getName());
    private ProxyFilterType mFilterType;
    private int mAddressListSize;

    public ProxyConfigFilterStatus(ControlMessage controlMessage) {
        super(controlMessage);
        this.mParameters = controlMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 3;
    }

    @Override
    byte[] getParameters() {
        return this.mParameters;
    }

    @Override
    void parseStatusParameters() {
        this.mFilterType = new ProxyFilterType(MeshParserUtils.unsignedByteToInt(this.mParameters[0]));
        this.mAddressListSize = MeshParserUtils.unsignedBytesToInt(this.mParameters[2], this.mParameters[1]);
        LOG.info("Filter type: " + this.mFilterType.getFilterTypeName());
        LOG.info("Filter size: " + this.mAddressListSize);
    }

    public ProxyFilterType getFilterType() {
        return this.mFilterType;
    }

    public int getListSize() {
        return this.mAddressListSize;
    }
}

