/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.Features;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.NodeKey;
import org.openremote.agent.protocol.bluetooth.mesh.Provisioner;
import org.openremote.agent.protocol.bluetooth.mesh.models.ConfigurationServerModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModelParser;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigCompositionDataStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelAppStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Element;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedBaseMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public final class ProvisionedMeshNode
extends ProvisionedBaseMeshNode {
    public static final Logger LOG = Logger.getLogger(ProvisionedMeshNode.class.getName());

    public ProvisionedMeshNode() {
    }

    public ProvisionedMeshNode(UnprovisionedMeshNode node) {
        this.uuid = node.getDeviceUuid().toString();
        this.isConfigured = node.isConfigured();
        this.nodeName = node.getNodeName();
        this.mAddedNetKeys.add(new NodeKey(node.getKeyIndex()));
        this.mFlags = node.getFlags();
        this.unicastAddress = node.getUnicastAddress();
        this.deviceKey = node.getDeviceKey();
        this.ttl = node.getTtl();
        NetworkKey networkKey = new NetworkKey(node.getKeyIndex(), node.getNetworkKey());
        this.mTimeStampInMillis = node.getTimeStamp();
    }

    public ProvisionedMeshNode(Provisioner provisioner, List<NetworkKey> netKeys, List<ApplicationKey> appKeys) {
        this.meshUuid = provisioner.getMeshUuid();
        this.uuid = provisioner.getProvisionerUuid();
        this.isConfigured = true;
        this.nodeName = provisioner.getProvisionerName();
        for (NetworkKey networkKey : netKeys) {
            this.mAddedNetKeys.add(new NodeKey(networkKey.getKeyIndex(), false));
        }
        for (ApplicationKey applicationKey : appKeys) {
            this.mAddedAppKeys.add(new NodeKey(applicationKey.getKeyIndex(), false));
        }
        if (provisioner.getProvisionerAddress() != null) {
            this.unicastAddress = provisioner.getProvisionerAddress();
        }
        this.sequenceNumber = 0;
        this.deviceKey = SecureUtils.generateRandomNumber();
        this.ttl = provisioner.getGlobalTtl();
        this.mTimeStampInMillis = System.currentTimeMillis();
        SigModel model = SigModelParser.getSigModel(1);
        HashMap<Integer, MeshModel> hashMap = new HashMap<Integer, MeshModel>();
        hashMap.put(((MeshModel)model).getModelId(), model);
        Element element = new Element(this.unicastAddress, 0, hashMap);
        HashMap<Integer, Element> elements = new HashMap<Integer, Element>();
        elements.put(this.unicastAddress, element);
        this.mElements = elements;
        this.nodeFeatures = new Features(2, 2, 2, 2);
    }

    public final Map<Integer, Element> getElements() {
        return this.mElements;
    }

    public final boolean hasUnicastAddress(int unicastAddress) {
        if (unicastAddress == this.getUnicastAddress()) {
            return true;
        }
        for (Element element : this.mElements.values()) {
            if (element.getElementAddress() != unicastAddress) continue;
            return true;
        }
        return false;
    }

    public final void setElements(Map<Integer, Element> elements) {
        this.mElements = elements;
    }

    public final byte[] getDeviceKey() {
        return this.deviceKey;
    }

    public void setDeviceKey(byte[] deviceKey) {
        this.deviceKey = deviceKey;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public final Integer getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public final void setCompanyIdentifier(Integer companyIdentifier) {
        this.companyIdentifier = companyIdentifier;
    }

    public final Integer getProductIdentifier() {
        return this.productIdentifier;
    }

    public final void setProductIdentifier(Integer productIdentifier) {
        this.productIdentifier = productIdentifier;
    }

    public final Integer getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public final void setVersionIdentifier(Integer versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public final Integer getCrpl() {
        return this.crpl;
    }

    public final void setCrpl(Integer crpl) {
        this.crpl = crpl;
    }

    public final Features getNodeFeatures() {
        return this.nodeFeatures;
    }

    public final void setNodeFeatures(Features features) {
        this.nodeFeatures = features;
    }

    public final List<NodeKey> getAddedNetKeys() {
        return Collections.unmodifiableList(this.mAddedNetKeys);
    }

    public final void setAddedNetKeys(List<NodeKey> addedNetKeyIndexes) {
        this.mAddedNetKeys = addedNetKeyIndexes;
    }

    protected final void setAddedNetKeyIndex(int index) {
        if (!MeshParserUtils.isNodeKeyExists(this.mAddedNetKeys, index)) {
            this.mAddedNetKeys.add(new NodeKey(index));
        }
    }

    protected final void updateAddedNetKey(int index) {
        NodeKey nodeKey = MeshParserUtils.getNodeKey(this.mAddedNetKeys, index);
        if (nodeKey != null) {
            nodeKey.setUpdated(true);
        }
    }

    protected final void updateNetKeyList(List<Integer> indexes) {
        this.mAddedNetKeys.clear();
        for (Integer index : indexes) {
            this.mAddedNetKeys.add(new NodeKey(index, false));
        }
    }

    protected final void removeAddedNetKeyIndex(int index) {
        for (int i = 0; i < this.mAddedNetKeys.size(); ++i) {
            int keyIndex = ((NodeKey)this.mAddedNetKeys.get(i)).getIndex();
            if (keyIndex != index) continue;
            this.mAddedNetKeys.remove(i);
            for (Element element : this.mElements.values()) {
                for (MeshModel model : element.getMeshModels().values()) {
                    ConfigurationServerModel configServerModel;
                    if (model.getModelId() != 0 || (configServerModel = (ConfigurationServerModel)model).getHeartbeatPublication() == null || configServerModel.getHeartbeatPublication().getNetKeyIndex() != index) continue;
                    configServerModel.setHeartbeatPublication(null);
                }
            }
            break;
        }
    }

    public final List<NodeKey> getAddedAppKeys() {
        return this.mAddedAppKeys;
    }

    public final void setAddedAppKeys(List<NodeKey> addedAppKeyIndexes) {
        this.mAddedAppKeys = addedAppKeyIndexes;
    }

    protected final void setAddedAppKeyIndex(int index) {
        if (!MeshParserUtils.isNodeKeyExists(this.mAddedAppKeys, index)) {
            this.mAddedAppKeys.add(new NodeKey(index));
        }
    }

    protected final void updateAddedAppKey(int index) {
        NodeKey nodeKey = MeshParserUtils.getNodeKey(this.mAddedNetKeys, index);
        if (nodeKey != null) {
            nodeKey.setUpdated(true);
        }
    }

    protected final void updateAppKeyList(int netKeyIndex, List<Integer> indexes, List<ApplicationKey> keyIndexes) {
        if (this.mAddedAppKeys.isEmpty()) {
            this.mAddedAppKeys.addAll(this.addAppKeyList(indexes, new ArrayList<NodeKey>()));
        } else {
            ArrayList<NodeKey> tempList = new ArrayList<NodeKey>(this.mAddedAppKeys);
            for (ApplicationKey applicationKey : keyIndexes) {
                if (applicationKey.getBoundNetKeyIndex() != netKeyIndex) continue;
                for (NodeKey nodeKey : this.mAddedAppKeys) {
                    if (nodeKey.getIndex() != applicationKey.getKeyIndex()) continue;
                    tempList.remove(nodeKey);
                }
            }
            this.mAddedAppKeys.clear();
            this.addAppKeyList(indexes, tempList);
            this.mAddedAppKeys.addAll(tempList);
        }
    }

    private List<NodeKey> addAppKeyList(List<Integer> indexes, ArrayList<NodeKey> tempList) {
        for (Integer index : indexes) {
            tempList.add(new NodeKey(index, false));
        }
        return tempList;
    }

    protected final void removeAddedAppKeyIndex(int index) {
        for (int i = 0; i < this.mAddedAppKeys.size(); ++i) {
            int keyIndex = ((NodeKey)this.mAddedAppKeys.get(i)).getIndex();
            if (keyIndex != index) continue;
            this.mAddedAppKeys.remove(i);
            for (Map.Entry<Integer, Element> elementEntry : this.getElements().entrySet()) {
                Element element = elementEntry.getValue();
                block2: for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                    MeshModel model = modelEntry.getValue();
                    if (model == null) continue;
                    for (int j = 0; j < model.getBoundAppKeyIndexes().size(); ++j) {
                        int boundKeyIndex = model.getBoundAppKeyIndexes().get(j);
                        if (boundKeyIndex != index) continue;
                        model.mBoundAppKeyIndexes.remove(j);
                        continue block2;
                    }
                }
            }
            break;
        }
    }

    protected final void setCompositionData(ConfigCompositionDataStatus configCompositionDataStatus) {
        this.companyIdentifier = configCompositionDataStatus.getCompanyIdentifier();
        this.productIdentifier = configCompositionDataStatus.getProductIdentifier();
        this.versionIdentifier = configCompositionDataStatus.getVersionIdentifier();
        this.crpl = configCompositionDataStatus.getCrpl();
        boolean relayFeatureSupported = configCompositionDataStatus.isRelayFeatureSupported();
        boolean proxyFeatureSupported = configCompositionDataStatus.isProxyFeatureSupported();
        boolean friendFeatureSupported = configCompositionDataStatus.isFriendFeatureSupported();
        boolean lowPowerFeatureSupported = configCompositionDataStatus.isLowPowerFeatureSupported();
        this.nodeFeatures = new Features(friendFeatureSupported ? 1 : 2, lowPowerFeatureSupported ? 1 : 2, proxyFeatureSupported ? 1 : 2, relayFeatureSupported ? 1 : 2);
        this.mElements.putAll(configCompositionDataStatus.getElements());
    }

    private int getFeatureState(Boolean feature) {
        if (feature != null && feature.booleanValue()) {
            return 2;
        }
        return 0;
    }

    protected final void setAppKeyBindStatus(ConfigModelAppStatus configModelAppStatus) {
        Element element;
        if (configModelAppStatus.isSuccessful() && (element = (Element)this.mElements.get(configModelAppStatus.getElementAddress())) != null) {
            int modelIdentifier = configModelAppStatus.getModelIdentifier();
            MeshModel model = element.getMeshModels().get(modelIdentifier);
            if (model != null) {
                int appKeyIndex = configModelAppStatus.getAppKeyIndex();
                model.setBoundAppKeyIndex(appKeyIndex);
            }
        }
    }

    protected final void setAppKeyUnbindStatus(ConfigModelAppStatus configModelAppStatus) {
        Element element;
        if (configModelAppStatus.isSuccessful() && (element = (Element)this.mElements.get(configModelAppStatus.getElementAddress())) != null) {
            int modelIdentifier = configModelAppStatus.getModelIdentifier();
            MeshModel model = element.getMeshModels().get(modelIdentifier);
            int appKeyIndex = configModelAppStatus.getAppKeyIndex();
            if (model != null) {
                model.removeBoundAppKeyIndex(appKeyIndex);
            }
        }
    }

    private void sortElements(Map<Integer, Element> unorderedElements) {
        Set<Integer> unorderedKeys = unorderedElements.keySet();
        ArrayList<Integer> orderedKeys = new ArrayList<Integer>(unorderedKeys);
        Collections.sort(orderedKeys);
        Iterator iterator = orderedKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.mElements.put(key, unorderedElements.get(key));
        }
    }

    void setSeqAuth(int src, int seqAuth) {
        this.mSeqAuth.put(src, seqAuth);
    }

    public Integer getSeqAuth(int src) {
        if (this.mSeqAuth.size() == 0) {
            return null;
        }
        return (Integer)this.mSeqAuth.get(src);
    }

    public boolean isExist(int modelId) {
        for (Map.Entry elementEntry : this.mElements.entrySet()) {
            Element element = (Element)elementEntry.getValue();
            for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                MeshModel model = modelEntry.getValue();
                if (model == null || model.getModelId() != modelId) continue;
                return true;
            }
        }
        return false;
    }

    public int incrementSequenceNumber() {
        return ++this.sequenceNumber;
    }
}

