/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openremote.agent.protocol.bluetooth.mesh.Features;
import org.openremote.agent.protocol.bluetooth.mesh.NodeKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Element;
import org.openremote.agent.protocol.bluetooth.mesh.utils.NetworkTransmitSettings;
import org.openremote.agent.protocol.bluetooth.mesh.utils.RelaySettings;

abstract class ProvisionedBaseMeshNode {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int UNSUPPORTED = 2;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    protected static final String TAG = ProvisionedBaseMeshNode.class.getSimpleName();
    public long mTimeStampInMillis;
    protected String nodeName = "My Node";
    protected Integer ttl = 5;
    protected Boolean secureNetworkBeaconSupported;
    protected NetworkTransmitSettings networkTransmitSettings;
    protected RelaySettings relaySettings;
    String meshUuid;
    String uuid;
    int security = 0;
    int unicastAddress;
    boolean isConfigured;
    byte[] deviceKey;
    int sequenceNumber = 0;
    Integer companyIdentifier = null;
    Integer productIdentifier = null;
    Integer versionIdentifier = null;
    Integer crpl = null;
    Features nodeFeatures = null;
    Map<Integer, Integer> mSeqAuth = new HashMap<Integer, Integer>();
    List<NodeKey> mAddedNetKeys = new ArrayList<NodeKey>();
    List<NodeKey> mAddedAppKeys = new ArrayList<NodeKey>();
    byte[] mFlags;
    Map<Integer, Element> mElements = new LinkedHashMap<Integer, Element>();
    boolean excluded = false;
    int nodeIdentityState;

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public final boolean isConfigured() {
        return this.isConfigured;
    }

    public final void setConfigured(boolean configured) {
        this.isConfigured = configured;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public final void setNodeName(String nodeName) {
        if (nodeName != null && nodeName.length() > 0) {
            this.nodeName = nodeName;
        }
    }

    public final int getUnicastAddress() {
        return this.unicastAddress;
    }

    public final void setUnicastAddress(int unicastAddress) {
        this.unicastAddress = unicastAddress;
    }

    public int getNumberOfElements() {
        return this.mElements.size();
    }

    public int getLastUnicastAddress() {
        int elementCount = this.getNumberOfElements();
        return elementCount == 1 ? this.unicastAddress : this.unicastAddress + (elementCount - 1);
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public final byte[] getFlags() {
        return this.mFlags;
    }

    public final void setFlags(byte[] flags) {
        this.mFlags = flags;
    }

    public long getTimeStamp() {
        return this.mTimeStampInMillis;
    }

    public void setTimeStamp(long timestamp) {
        this.mTimeStampInMillis = timestamp;
    }

    public int getSecurity() {
        return this.security;
    }

    public void setSecurity(int security) {
        this.security = security;
    }

    @Deprecated
    public boolean isBlackListed() {
        return this.isExcluded();
    }

    @Deprecated
    public void setBlackListed(boolean blackListed) {
        this.setExcluded(blackListed);
    }

    public Boolean isSecureNetworkBeaconSupported() {
        return this.secureNetworkBeaconSupported;
    }

    public void setSecureNetworkBeaconSupported(Boolean enable) {
        this.secureNetworkBeaconSupported = enable;
    }

    public NetworkTransmitSettings getNetworkTransmitSettings() {
        return this.networkTransmitSettings;
    }

    public void setNetworkTransmitSettings(NetworkTransmitSettings networkTransmitSettings) {
        this.networkTransmitSettings = networkTransmitSettings;
    }

    public RelaySettings getRelaySettings() {
        return this.relaySettings;
    }

    public void setRelaySettings(RelaySettings relaySettings) {
        this.relaySettings = relaySettings;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public int getNodeIdentityState() {
        return this.nodeIdentityState;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }
}

