/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.Provisioner;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LowerTransportLayer;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.transport.NetworkLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ExtendedInvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

abstract class NetworkLayer
extends LowerTransportLayer {
    public static final Logger LOG = Logger.getLogger(NetworkLayer.class.getName());
    NetworkLayerCallbacks mNetworkLayerCallbacks;
    private Map<Integer, byte[]> segmentedAccessMessagesMessages;
    private Map<Integer, byte[]> segmentedControlMessagesMessages;

    NetworkLayer() {
    }

    abstract void setNetworkLayerCallbacks(NetworkLayerCallbacks var1);

    @Override
    protected final void createMeshMessage(Message message) {
        if (message instanceof AccessMessage) {
            super.createMeshMessage(message);
        } else {
            super.createMeshMessage(message);
        }
        this.createNetworkLayerPDU(message);
    }

    @Override
    protected final void createVendorMeshMessage(Message message) {
        if (message instanceof AccessMessage) {
            super.createVendorMeshMessage(message);
        } else {
            super.createVendorMeshMessage(message);
        }
        this.createNetworkLayerPDU(message);
    }

    @Override
    public final synchronized Message createNetworkLayerPDU(Message message) {
        SecureUtils.K2Output k2Output = this.getK2Output(message);
        byte nid = k2Output.getNid();
        byte[] encryptionKey = k2Output.getEncryptionKey();
        LOG.info("Encryption key: " + MeshParserUtils.bytesToHex(encryptionKey, false));
        byte[] privacyKey = k2Output.getPrivacyKey();
        LOG.info("Privacy key: " + MeshParserUtils.bytesToHex(privacyKey, false));
        int ctl = message.getCtl();
        int ttl = message.getTtl();
        int ivi = message.getIvIndex()[3] & 1;
        byte iviNID = (byte)(ivi << 7 | nid);
        byte ctlTTL = (byte)(ctl << 7 | ttl);
        int src = message.getSrc();
        HashMap<Integer, byte[]> encryptedPduPayload = new HashMap<Integer, byte[]>();
        ArrayList<byte[]> sequenceNumbers = new ArrayList<byte[]>();
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(message.getSrc());
        int pduType = message.getPduType();
        switch (message.getPduType()) {
            case 0: {
                byte[] lowerTransportPdu;
                int i;
                Map<Integer, byte[]> lowerTransportPduMap = message instanceof AccessMessage ? ((AccessMessage)message).getLowerTransportAccessPdu() : ((ControlMessage)message).getLowerTransportControlPdu();
                for (i = 0; i < lowerTransportPduMap.size(); ++i) {
                    lowerTransportPdu = lowerTransportPduMap.get(i);
                    if (i != 0) {
                        node.setSequenceNumber(MeshParserUtils.convert24BitsToInt(message.getSequenceNumber()));
                        byte[] sequenceNumber = MeshParserUtils.getSequenceNumberBytes(node.incrementSequenceNumber());
                        message.setSequenceNumber(sequenceNumber);
                    }
                    sequenceNumbers.add(message.getSequenceNumber());
                    LOG.info("Sequence Number: " + MeshParserUtils.bytesToHex((byte[])sequenceNumbers.get(i), false));
                    byte[] nonce = NetworkLayer.createNetworkNonce(ctlTTL, (byte[])sequenceNumbers.get(i), src, message.getIvIndex());
                    byte[] encryptedPayload = this.encryptPdu(lowerTransportPdu, encryptionKey, nonce, message.getDst(), SecureUtils.getNetMicLength(message.getCtl()));
                    encryptedPduPayload.put(i, encryptedPayload);
                    LOG.info("Encrypted Network payload: " + MeshParserUtils.bytesToHex(encryptedPayload, false));
                }
                break;
            }
            case 2: {
                byte[] lowerTransportPdu;
                int i;
                Map<Integer, byte[]> lowerTransportPduMap = ((ControlMessage)message).getLowerTransportControlPdu();
                for (i = 0; i < lowerTransportPduMap.size(); ++i) {
                    lowerTransportPdu = lowerTransportPduMap.get(i);
                    byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(node.incrementSequenceNumber());
                    message.setSequenceNumber(sequenceNum);
                    sequenceNumbers.add(message.getSequenceNumber());
                    byte[] nonce = NetworkLayer.createProxyNonce(message.getSequenceNumber(), src, message.getIvIndex());
                    byte[] encryptedPayload = this.encryptPdu(lowerTransportPdu, encryptionKey, nonce, message.getDst(), SecureUtils.getNetMicLength(message.getCtl()));
                    encryptedPduPayload.put(i, encryptedPayload);
                    LOG.info("Encrypted Network payload: " + MeshParserUtils.bytesToHex(encryptedPayload, false));
                }
                break;
            }
        }
        HashMap<Integer, byte[]> pduArray = new HashMap<Integer, byte[]>();
        for (int i = 0; i < encryptedPduPayload.size(); ++i) {
            byte[] encryptedPayload = (byte[])encryptedPduPayload.get(i);
            byte[] privacyRandom = NetworkLayer.createPrivacyRandom(encryptedPayload);
            byte[] pecb = NetworkLayer.createPECB(message.getIvIndex(), privacyRandom, privacyKey);
            byte[] header = this.obfuscateNetworkHeader(ctlTTL, (byte[])sequenceNumbers.get(i), src, pecb);
            byte[] pdu = ByteBuffer.allocate(2 + header.length + encryptedPayload.length).order(ByteOrder.BIG_ENDIAN).put((byte)pduType).put(iviNID).put(header).put(encryptedPayload).array();
            pduArray.put(i, pdu);
            message.setNetworkLayerPdu(pduArray);
        }
        return message;
    }

    final synchronized Message createRetransmitNetworkLayerPDU(Message message, int segment) {
        SecureUtils.K2Output k2Output = this.getK2Output(message);
        byte nid = k2Output.getNid();
        byte[] encryptionKey = k2Output.getEncryptionKey();
        LOG.info("Encryption key: " + MeshParserUtils.bytesToHex(encryptionKey, false));
        byte[] privacyKey = k2Output.getPrivacyKey();
        LOG.info("Privacy key: " + MeshParserUtils.bytesToHex(privacyKey, false));
        int ctl = message.getCtl();
        int ttl = message.getTtl();
        int ivi = message.getIvIndex()[3] & 1;
        byte iviNID = (byte)(ivi << 7 | nid);
        byte ctlTTL = (byte)(ctl << 7 | ttl);
        int src = message.getSrc();
        Map<Integer, byte[]> lowerTransportPduMap = message instanceof AccessMessage ? ((AccessMessage)message).getLowerTransportAccessPdu() : ((ControlMessage)message).getLowerTransportControlPdu();
        byte[] encryptedNetworkPayload = null;
        int pduType = message.getPduType();
        if (message.getPduType() == 0) {
            ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(message.getSrc());
            byte[] lowerTransportPdu = lowerTransportPduMap.get(segment);
            node.setSequenceNumber(MeshParserUtils.convert24BitsToInt(message.getSequenceNumber()));
            byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(node.incrementSequenceNumber());
            message.setSequenceNumber(sequenceNum);
            LOG.info("Sequence Number: " + MeshParserUtils.bytesToHex(sequenceNum, false));
            byte[] nonce = NetworkLayer.createNetworkNonce(ctlTTL, sequenceNum, src, message.getIvIndex());
            encryptedNetworkPayload = this.encryptPdu(lowerTransportPdu, encryptionKey, nonce, message.getDst(), SecureUtils.getNetMicLength(message.getCtl()));
            if (encryptedNetworkPayload == null) {
                return null;
            }
            LOG.info("Encrypted Network payload: " + MeshParserUtils.bytesToHex(encryptedNetworkPayload, false));
        }
        HashMap<Integer, byte[]> pduArray = new HashMap<Integer, byte[]>();
        if (encryptedNetworkPayload == null) {
            return null;
        }
        byte[] privacyRandom = NetworkLayer.createPrivacyRandom(encryptedNetworkPayload);
        byte[] pecb = NetworkLayer.createPECB(message.getIvIndex(), privacyRandom, privacyKey);
        byte[] header = this.obfuscateNetworkHeader(ctlTTL, message.getSequenceNumber(), src, pecb);
        byte[] pdu = ByteBuffer.allocate(2 + header.length + encryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put((byte)pduType).put(iviNID).put(header).put(encryptedNetworkPayload).array();
        pduArray.put(segment, pdu);
        message.setNetworkLayerPdu(pduArray);
        return message;
    }

    final synchronized Message parseMeshMessage(NetworkKey key, ProvisionedMeshNode node, byte[] data, byte[] networkHeader, byte[] decryptedNetworkPayload, int ivIndex, byte[] sequenceNumber) throws ExtendedInvalidCipherTextException {
        this.mMeshNode = node;
        Provisioner provisioner = this.mNetworkLayerCallbacks.getProvisioner();
        byte ctlTtl = networkHeader[0];
        int ctl = ctlTtl >> 7 & 1;
        int ttl = ctlTtl & 0x7F;
        int src = MeshParserUtils.unsignedBytesToInt(networkHeader[5], networkHeader[4]);
        if (ctl == 1) {
            return this.parseControlMessage(key, provisioner.getProvisionerAddress(), data, networkHeader, decryptedNetworkPayload, src, sequenceNumber);
        }
        return this.parseAccessMessage(key, data, networkHeader, decryptedNetworkPayload, src, sequenceNumber, ivIndex);
    }

    private AccessMessage parseAccessMessage(NetworkKey key, byte[] data, byte[] networkHeader, byte[] decryptedNetworkPayload, int src, byte[] sequenceNumber, int ivIndex) throws ExtendedInvalidCipherTextException {
        try {
            int receivedTtl = networkHeader[0] & 0x7F;
            int dst = MeshParserUtils.unsignedBytesToInt(decryptedNetworkPayload[1], decryptedNetworkPayload[0]);
            LOG.info("Dst: " + MeshAddress.formatAddress(dst, true));
            if (this.isSegmentedMessage(decryptedNetworkPayload[2])) {
                LOG.info("Received a segmented access message from: " + MeshAddress.formatAddress(src, false));
                if (!this.mMeshNode.hasUnicastAddress(src)) {
                    LOG.info("Segment received is from a different src than the one we are processing, let's drop it");
                    return null;
                }
                if (this.segmentedAccessMessagesMessages == null) {
                    this.segmentedAccessMessagesMessages = new HashMap<Integer, byte[]>();
                    this.segmentedAccessMessagesMessages.put(0, data);
                } else {
                    int k = this.segmentedAccessMessagesMessages.size();
                    this.segmentedAccessMessagesMessages.put(k, data);
                }
                byte[] pdu = ByteBuffer.allocate(2 + networkHeader.length + decryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put(data, 0, 2).put(networkHeader).put(decryptedNetworkPayload).array();
                int ttl = receivedTtl == 0 ? receivedTtl : this.mNetworkLayerCallbacks.getProvisioner().getGlobalTtl();
                AccessMessage message = this.parseSegmentedAccessLowerTransportPDU(ttl, pdu, ivIndex, sequenceNumber);
                if (message != null) {
                    HashMap<Integer, byte[]> segmentedMessages = new HashMap<Integer, byte[]>();
                    for (Integer index : this.segmentedAccessMessagesMessages.keySet()) {
                        segmentedMessages.put(index, (byte[])this.segmentedAccessMessagesMessages.get(index).clone());
                    }
                    this.segmentedAccessMessagesMessages = null;
                    message.setNetworkKey(key);
                    message.setIvIndex(MeshParserUtils.intToBytes(ivIndex));
                    message.setNetworkLayerPdu(segmentedMessages);
                    message.setTtl(receivedTtl);
                    message.setSrc(src);
                    message.setDst(dst);
                    this.parseUpperTransportPDU(message);
                    this.parseAccessLayerPDU(message);
                }
                return message;
            }
            byte[] pdu = ByteBuffer.allocate(2 + networkHeader.length + decryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put(data, 0, 2).put(networkHeader).put(decryptedNetworkPayload).array();
            AccessMessage message = this.parseUnsegmentedAccessLowerTransportPDU(pdu, ivIndex, sequenceNumber);
            if (message == null) {
                return null;
            }
            message.setNetworkKey(key);
            message.setIvIndex(MeshParserUtils.intToBytes(ivIndex));
            HashMap<Integer, byte[]> pduArray = new HashMap<Integer, byte[]>();
            pduArray.put(0, data);
            message.setNetworkLayerPdu(pduArray);
            message.setTtl(receivedTtl);
            message.setSrc(src);
            message.setDst(dst);
            message.setSequenceNumber(sequenceNumber);
            this.parseUpperTransportPDU(message);
            this.parseAccessLayerPDU(message);
            return message;
        }
        catch (InvalidCipherTextException ex) {
            throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), NetworkLayer.class.getSimpleName());
        }
    }

    private ControlMessage parseControlMessage(NetworkKey key, Integer provisionerAddress, byte[] data, byte[] networkHeader, byte[] decryptedNetworkPayload, int src, byte[] sequenceNumber) throws ExtendedInvalidCipherTextException {
        try {
            int ttl = networkHeader[0] & 0x7F;
            int dst = MeshParserUtils.unsignedBytesToInt(decryptedNetworkPayload[1], decryptedNetworkPayload[0]);
            byte[] decryptedProxyPdu = ByteBuffer.allocate(2 + networkHeader.length + decryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put(data, 0, 2).put(networkHeader).put(decryptedNetworkPayload).array();
            byte pduType = data[0];
            switch (pduType) {
                case 0: {
                    if (provisionerAddress == null) {
                        return null;
                    }
                    if (provisionerAddress != dst) {
                        LOG.info("Received a control message that was not directed to us, so we drop it");
                        return null;
                    }
                    if (this.isSegmentedMessage(decryptedNetworkPayload[2])) {
                        return this.parseSegmentedControlMessage(key, data, decryptedProxyPdu, ttl, src, dst);
                    }
                    return this.parseUnsegmentedControlMessage(key, data, decryptedProxyPdu, ttl, src, dst, sequenceNumber);
                }
                case 2: {
                    return this.parseUnsegmentedControlMessage(key, data, decryptedProxyPdu, ttl, src, dst, sequenceNumber);
                }
            }
            return null;
        }
        catch (InvalidCipherTextException ex) {
            throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), NetworkLayer.class.getSimpleName());
        }
    }

    private ControlMessage parseUnsegmentedControlMessage(NetworkKey key, byte[] data, byte[] decryptedProxyPdu, int ttl, int src, int dst, byte[] sequenceNumber) throws ExtendedInvalidCipherTextException {
        ControlMessage message = new ControlMessage();
        message.setNetworkKey(key);
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        HashMap<Integer, byte[]> proxyPduArray = new HashMap<Integer, byte[]>();
        proxyPduArray.put(0, data);
        message.setNetworkLayerPdu(proxyPduArray);
        message.setTtl(ttl);
        message.setSrc(src);
        message.setDst(dst);
        message.setSequenceNumber(sequenceNumber);
        message.setSegmented(false);
        this.parseUnsegmentedControlLowerTransportPDU(message, decryptedProxyPdu);
        return message;
    }

    private ControlMessage parseSegmentedControlMessage(NetworkKey key, byte[] data, byte[] decryptedProxyPdu, int ttl, int src, int dst) {
        if (this.segmentedControlMessagesMessages == null) {
            this.segmentedControlMessagesMessages = new HashMap<Integer, byte[]>();
            this.segmentedControlMessagesMessages.put(0, data);
        } else {
            int k = this.segmentedControlMessagesMessages.size();
            this.segmentedAccessMessagesMessages.put(k, data);
        }
        ControlMessage message = this.parseSegmentedControlLowerTransportPDU(decryptedProxyPdu);
        if (message != null) {
            HashMap<Integer, byte[]> segmentedMessages = new HashMap<Integer, byte[]>();
            for (Integer index : this.segmentedControlMessagesMessages.keySet()) {
                segmentedMessages.put(index, (byte[])this.segmentedControlMessagesMessages.get(index).clone());
            }
            this.segmentedControlMessagesMessages = null;
            message.setNetworkKey(key);
            message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
            message.setNetworkLayerPdu(segmentedMessages);
            message.setTtl(ttl);
            message.setSrc(src);
            message.setDst(dst);
        }
        return message;
    }

    private SecureUtils.K2Output getK2Output(Message message) {
        NetworkKey networkKey;
        if (message.getAkf() == 0) {
            networkKey = this.mNetworkLayerCallbacks.getPrimaryNetworkKey();
        } else {
            int netKeyIndex = message.getApplicationKey().getBoundNetKeyIndex();
            networkKey = this.mNetworkLayerCallbacks.getNetworkKey(netKeyIndex);
        }
        return networkKey.getTxDerivatives();
    }

    private byte[] obfuscateNetworkHeader(byte ctlTTL, byte[] sequenceNumber, int src, byte[] pecb) {
        ByteBuffer buffer = ByteBuffer.allocate(1 + sequenceNumber.length + 2).order(ByteOrder.BIG_ENDIAN);
        buffer.put(ctlTTL);
        buffer.put(sequenceNumber);
        buffer.putShort((short)src);
        byte[] headerBuffer = buffer.array();
        ByteBuffer bufferPECB = ByteBuffer.allocate(6);
        bufferPECB.put(pecb, 0, 6);
        byte[] obfuscated = new byte[6];
        for (int i = 0; i < 6; ++i) {
            obfuscated[i] = (byte)(headerBuffer[i] ^ pecb[i]);
        }
        return obfuscated;
    }

    static byte[] deObfuscateNetworkHeader(byte[] pdu, byte[] ivIndex, byte[] privacyKey) {
        ByteBuffer obfuscatedNetworkBuffer = ByteBuffer.allocate(6);
        obfuscatedNetworkBuffer.order(ByteOrder.BIG_ENDIAN);
        obfuscatedNetworkBuffer.put(pdu, 2, 6);
        byte[] obfuscatedData = obfuscatedNetworkBuffer.array();
        ByteBuffer privacyRandomBuffer = ByteBuffer.allocate(7);
        privacyRandomBuffer.order(ByteOrder.BIG_ENDIAN);
        privacyRandomBuffer.put(pdu, 8, 7);
        byte[] privacyRandom = NetworkLayer.createPrivacyRandom(privacyRandomBuffer.array());
        byte[] pecb = NetworkLayer.createPECB(ivIndex, privacyRandom, privacyKey);
        byte[] deObfuscatedData = new byte[6];
        for (int i = 0; i < 6; ++i) {
            deObfuscatedData[i] = (byte)(obfuscatedData[i] ^ pecb[i]);
        }
        return deObfuscatedData;
    }

    private static byte[] createPrivacyRandom(byte[] encryptedUpperTransportPDU) {
        byte[] privacyRandom = new byte[7];
        System.arraycopy(encryptedUpperTransportPDU, 0, privacyRandom, 0, privacyRandom.length);
        return privacyRandom;
    }

    private static byte[] createPECB(byte[] ivIndex, byte[] privacyRandom, byte[] privacyKey) {
        ByteBuffer buffer = ByteBuffer.allocate(5 + privacyRandom.length + ivIndex.length);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(new byte[]{0, 0, 0, 0, 0});
        buffer.put(ivIndex);
        buffer.put(privacyRandom);
        byte[] temp = buffer.array();
        return SecureUtils.encryptWithAES(temp, privacyKey);
    }

    static byte[] createNetworkNonce(byte ctlTTL, byte[] sequenceNumber, int src, byte[] ivIndex) {
        ByteBuffer networkNonce = ByteBuffer.allocate(13);
        networkNonce.put((byte)0);
        networkNonce.put(ctlTTL);
        networkNonce.put(sequenceNumber);
        networkNonce.putShort((short)src);
        networkNonce.put(new byte[]{0, 0});
        networkNonce.put(ivIndex);
        return networkNonce.array();
    }

    static byte[] createProxyNonce(byte[] sequenceNumber, int src, byte[] ivIndex) {
        ByteBuffer applicationNonceBuffer = ByteBuffer.allocate(13);
        applicationNonceBuffer.put((byte)3);
        applicationNonceBuffer.put((byte)0);
        applicationNonceBuffer.put(sequenceNumber);
        applicationNonceBuffer.putShort((short)src);
        applicationNonceBuffer.put(new byte[]{0, 0});
        applicationNonceBuffer.put(ivIndex);
        return applicationNonceBuffer.array();
    }

    private byte[] encryptPdu(byte[] lowerTransportPdu, byte[] encryptionKey, byte[] nonce, int dst, int micLength) {
        byte[] unencryptedNetworkPayload = ByteBuffer.allocate(2 + lowerTransportPdu.length).order(ByteOrder.BIG_ENDIAN).putShort((short)dst).put(lowerTransportPdu).array();
        return SecureUtils.encryptCCM(unencryptedNetworkPayload, encryptionKey, nonce, micLength);
    }
}

