/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LowerTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.transport.NetworkLayer;
import org.openremote.agent.protocol.bluetooth.mesh.transport.NetworkLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.UpperTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.container.concurrent.ContainerScheduledExecutor;

final class MeshTransport
extends NetworkLayer {
    public static final Logger LOG = Logger.getLogger(MeshTransport.class.getName());
    private static final int PROXY_CONFIGURATION_TTL = 0;
    private final ScheduledThreadPoolExecutor executor;
    private final List<Future<?>> tasks = new CopyOnWriteArrayList();

    MeshTransport() {
        this.executor = new ContainerScheduledExecutor("Bluetooth-Mesh Thread Pool", 2);
        this.initHandler();
    }

    MeshTransport(ProvisionedMeshNode node) {
        this.mMeshNode = node;
        this.executor = new ContainerScheduledExecutor("Bluetooth-Mesh Thread Pool", 2);
        this.initHandler();
    }

    @Override
    protected Future<?> startTask(Runnable runnable, Long delay) {
        Future<?> task = null;
        task = delay == null || delay == 0L ? this.executor.submit(runnable) : this.executor.schedule(runnable, (long)delay, TimeUnit.MILLISECONDS);
        this.tasks.add(task);
        return task;
    }

    @Override
    protected void stopTask(Future<?> task) {
        if (task != null) {
            task.cancel(true);
            this.tasks.remove(task);
        }
    }

    @Override
    protected void stopAllTasks() {
        ArrayList allTasks = new ArrayList(this.tasks);
        for (Future future : allTasks) {
            this.stopTask(future);
        }
    }

    protected final void initHandler() {
    }

    @Override
    protected final synchronized void setLowerTransportLayerCallbacks(LowerTransportLayerCallbacks callbacks) {
        this.mLowerTransportLayerCallbacks = callbacks;
    }

    @Override
    final synchronized void setNetworkLayerCallbacks(NetworkLayerCallbacks callbacks) {
        this.mNetworkLayerCallbacks = callbacks;
    }

    @Override
    final synchronized void setUpperTransportLayerCallbacks(UpperTransportLayerCallbacks callbacks) {
        this.mUpperTransportLayerCallbacks = callbacks;
    }

    final synchronized ControlMessage createSegmentBlockAcknowledgementMessage(ControlMessage controlMessage) {
        this.createLowerTransportControlPDU(controlMessage);
        this.createNetworkLayerPDU(controlMessage);
        return controlMessage;
    }

    final synchronized AccessMessage createMeshMessage(int src, int dst, Integer ttl, byte[] key, int akf, int aid, int aszmic, int accessOpCode, byte[] accessMessageParameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        LOG.info("Src address: " + MeshAddress.formatAddress(src, false));
        LOG.info("Dst address: " + MeshAddress.formatAddress(dst, false));
        LOG.info("Key: " + MeshParserUtils.bytesToHex(key, false));
        LOG.info("akf: " + akf);
        LOG.info("aid: " + aid);
        LOG.info("aszmic: " + aszmic);
        LOG.info("Sequence number: " + sequenceNumber);
        LOG.info("Access message opcode: " + Integer.toHexString(accessOpCode));
        LOG.info("Access message parameters: " + MeshParserUtils.bytesToHex(accessMessageParameters, false));
        AccessMessage message = new AccessMessage();
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(ttl == null ? node.getTtl() : ttl);
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setDeviceKey(key);
        message.setAkf(akf);
        message.setAid(aid);
        message.setAszmic(aszmic);
        message.setOpCode(accessOpCode);
        message.setParameters(accessMessageParameters);
        message.setPduType(0);
        super.createMeshMessage(message);
        return message;
    }

    final synchronized AccessMessage createMeshMessage(int src, int dst, UUID label, Integer ttl, ApplicationKey key, int akf, int aid, int aszmic, int accessOpCode, byte[] accessMessageParameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        LOG.info("Src address: " + MeshAddress.formatAddress(src, false));
        LOG.info("Dst address: " + MeshAddress.formatAddress(dst, false));
        LOG.info("Key: " + MeshParserUtils.bytesToHex(key.getKey(), false));
        LOG.info("akf: " + akf);
        LOG.info("aid: " + aid);
        LOG.info("aszmic: " + aszmic);
        LOG.info("Sequence number: " + sequenceNumber);
        LOG.info("Access message opcode: " + Integer.toHexString(accessOpCode));
        LOG.info("Access message parameters: " + MeshParserUtils.bytesToHex(accessMessageParameters, false));
        AccessMessage message = new AccessMessage();
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(ttl == null ? node.getTtl() : ttl);
        if (label != null) {
            message.setLabel(label);
        }
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setApplicationKey(key);
        message.setAkf(akf);
        message.setAid(aid);
        message.setAszmic(aszmic);
        message.setOpCode(accessOpCode);
        message.setParameters(accessMessageParameters);
        message.setPduType(0);
        super.createMeshMessage(message);
        return message;
    }

    final synchronized AccessMessage createVendorMeshMessage(int companyIdentifier, int src, int dst, UUID label, Integer ttl, ApplicationKey key, int akf, int aid, int aszmic, int accessOpCode, byte[] accessMessageParameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        LOG.info("Src address: " + MeshAddress.formatAddress(src, false));
        LOG.info("Dst address: " + MeshAddress.formatAddress(dst, false));
        LOG.info("Key: " + MeshParserUtils.bytesToHex(key.getKey(), false));
        LOG.info("akf: " + akf);
        LOG.info("aid: " + aid);
        LOG.info("aszmic: " + aszmic);
        LOG.info("Sequence number: " + sequenceNumber);
        LOG.info("Access message opcode: " + Integer.toHexString(accessOpCode));
        LOG.info("Access message parameters: " + MeshParserUtils.bytesToHex(accessMessageParameters, false));
        AccessMessage message = new AccessMessage();
        message.setCompanyIdentifier(companyIdentifier);
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(ttl == null ? node.getTtl() : ttl);
        if (label != null) {
            message.setLabel(label);
        }
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setApplicationKey(key);
        message.setAkf(akf);
        message.setAid(aid);
        message.setAszmic(aszmic);
        message.setOpCode(accessOpCode);
        message.setParameters(accessMessageParameters);
        message.setPduType(0);
        super.createVendorMeshMessage(message);
        return message;
    }

    final synchronized ControlMessage createProxyConfigurationMessage(int src, int dst, int opcode, byte[] parameters) {
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(src);
        int sequenceNumber = node.incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        LOG.info("Src address: " + MeshAddress.formatAddress(src, false));
        LOG.info("Dst address: " + MeshAddress.formatAddress(dst, false));
        LOG.info("Sequence number: " + sequenceNumber);
        LOG.info("Control message opcode: " + Integer.toHexString(opcode));
        LOG.info("Control message parameters: " + MeshParserUtils.bytesToHex(parameters, false));
        ControlMessage message = new ControlMessage();
        message.setSrc(src);
        message.setDst(dst);
        message.setTtl(node.getTtl());
        message.setTtl(0);
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        message.setSequenceNumber(sequenceNum);
        message.setOpCode(opcode);
        message.setParameters(parameters);
        message.setPduType(2);
        super.createMeshMessage(message);
        return message;
    }

    final synchronized Message createRetransmitMeshMessage(Message message, int segment) {
        return this.createRetransmitNetworkLayerPDU(message, segment);
    }
}

