/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelPublicationStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.PublicationSettings;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public abstract class MeshModel {
    protected int mModelId;
    final List<Integer> mBoundAppKeyIndexes = new ArrayList<Integer>();
    final Map<Integer, String> mBoundAppKeys = new LinkedHashMap<Integer, String>();
    final List<Integer> subscriptionAddresses = new ArrayList<Integer>();
    final List<UUID> labelUuids = new ArrayList<UUID>();
    PublicationSettings mPublicationSettings;
    protected int currentScene;
    protected int targetScene;
    protected List<Integer> sceneNumbers = new ArrayList<Integer>();

    public MeshModel(int modelId) {
        this.mModelId = modelId;
    }

    MeshModel() {
    }

    public abstract int getModelId();

    public abstract String getModelName();

    public List<Integer> getBoundAppKeyIndexes() {
        return Collections.unmodifiableList(this.mBoundAppKeyIndexes);
    }

    public void setBoundAppKeyIndex(int appKeyIndex) {
        if (!this.mBoundAppKeyIndexes.contains(appKeyIndex)) {
            this.mBoundAppKeyIndexes.add(appKeyIndex);
        }
    }

    public void setBoundAppKeyIndexes(List<Integer> indexes) {
        this.mBoundAppKeyIndexes.clear();
        this.mBoundAppKeyIndexes.addAll(indexes);
    }

    public void removeBoundAppKeyIndex(int appKeyIndex) {
        if (this.mBoundAppKeyIndexes.contains(appKeyIndex)) {
            int position = this.mBoundAppKeyIndexes.indexOf(appKeyIndex);
            this.mBoundAppKeyIndexes.remove(position);
        }
    }

    public List<Integer> getSubscribedAddresses() {
        return Collections.unmodifiableList(this.subscriptionAddresses);
    }

    public List<UUID> getLabelUUID() {
        return Collections.unmodifiableList(this.labelUuids);
    }

    public UUID getLabelUUID(int address) {
        return MeshAddress.getLabelUuid(this.labelUuids, address);
    }

    protected void setPublicationStatus(ConfigModelPublicationStatus status, UUID labelUUID) {
        if (status.isSuccessful()) {
            this.mPublicationSettings = !MeshAddress.isValidUnassignedAddress(status.getPublishAddress()) ? new PublicationSettings(status.getPublishAddress(), labelUUID, status.getAppKeyIndex(), status.getCredentialFlag(), status.getPublishTtl(), status.getPublicationSteps(), status.getPublicationResolution(), status.getPublishRetransmitCount(), status.getPublishRetransmitIntervalSteps()) : null;
        }
    }

    protected void updatePublicationStatus(ConfigModelPublicationStatus status) {
        if (status.isSuccessful() && this.mPublicationSettings != null) {
            this.mPublicationSettings.setPublishAddress(status.getPublishAddress());
            if (!MeshAddress.isValidVirtualAddress(status.getPublishAddress())) {
                this.mPublicationSettings.setLabelUUID(null);
            }
            this.mPublicationSettings.setAppKeyIndex(status.getAppKeyIndex());
            this.mPublicationSettings.setCredentialFlag(status.getCredentialFlag());
            this.mPublicationSettings.setPublishTtl(status.getPublishTtl());
            this.mPublicationSettings.setPublicationSteps(status.getPublicationSteps());
            this.mPublicationSettings.setPublicationResolution(status.getPublicationResolution());
            this.mPublicationSettings.setPublishRetransmitCount(status.getPublishRetransmitCount());
            this.mPublicationSettings.setPublishRetransmitIntervalSteps(status.getPublishRetransmitIntervalSteps());
        }
    }

    public PublicationSettings getPublicationSettings() {
        return this.mPublicationSettings;
    }

    public void setPublicationSettings(PublicationSettings publicationSettings) {
        this.mPublicationSettings = publicationSettings;
    }

    protected void addSubscriptionAddress(int subscriptionAddress) {
        if (!this.subscriptionAddresses.contains(subscriptionAddress)) {
            this.subscriptionAddresses.add(subscriptionAddress);
        }
    }

    protected void addSubscriptionAddress(UUID labelUuid, int address) {
        if (!this.labelUuids.contains(labelUuid)) {
            this.labelUuids.add(labelUuid);
        }
        if (!this.subscriptionAddresses.contains(address)) {
            this.subscriptionAddresses.add(address);
        }
    }

    protected void removeSubscriptionAddress(Integer address) {
        this.subscriptionAddresses.remove(address);
    }

    protected void removeSubscriptionAddress(UUID labelUuid, Integer address) {
        this.labelUuids.remove(labelUuid);
        this.removeSubscriptionAddress(address);
    }

    protected void removeAllSubscriptionAddresses() {
        this.labelUuids.clear();
        this.subscriptionAddresses.clear();
    }

    protected void overwriteSubscriptionAddress(Integer subscriptionAddress) {
        this.subscriptionAddresses.clear();
        this.addSubscriptionAddress(subscriptionAddress);
    }

    protected void overwriteSubscriptionAddress(UUID labelUuid, Integer address) {
        this.labelUuids.clear();
        this.addSubscriptionAddress(labelUuid, address);
        this.overwriteSubscriptionAddress(address);
    }

    protected void updateSubscriptionAddressesList(List<Integer> addresses) {
        this.subscriptionAddresses.clear();
        this.subscriptionAddresses.addAll(addresses);
    }
}

