/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.InternalMeshMsgHandlerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LowerTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshTransport;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

abstract class MeshMessageState
implements LowerTransportLayerCallbacks {
    public static final Logger LOG = Logger.getLogger(MeshMessageState.class.getName());
    MeshMessage mMeshMessage;
    final MeshTransport mMeshTransport;
    private final InternalMeshMsgHandlerCallbacks meshMessageHandlerCallbacks;
    protected InternalTransportCallbacks mInternalTransportCallbacks;
    MeshStatusCallbacks mMeshStatusCallbacks;
    int mSrc;
    int mDst;
    protected Message message;

    MeshMessageState(MeshMessage meshMessage, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) {
        this.mMeshMessage = meshMessage;
        if (meshMessage != null) {
            this.message = meshMessage.getMessage();
        }
        this.meshMessageHandlerCallbacks = callbacks;
        this.mMeshTransport = meshTransport;
        this.mMeshTransport.setLowerTransportLayerCallbacks(this);
    }

    synchronized void setTransportCallbacks(InternalTransportCallbacks callbacks) {
        this.mInternalTransportCallbacks = callbacks;
    }

    synchronized void setStatusCallbacks(MeshStatusCallbacks callbacks) {
        this.mMeshStatusCallbacks = callbacks;
    }

    abstract MessageState getState();

    synchronized MeshTransport getMeshTransport() {
        return this.mMeshTransport;
    }

    public synchronized MeshMessage getMeshMessage() {
        return this.mMeshMessage;
    }

    public synchronized void executeSend() {
        if (this.message.getNetworkLayerPdu().size() > 0) {
            for (int i = 0; i < this.message.getNetworkLayerPdu().size(); ++i) {
                this.mInternalTransportCallbacks.onMeshPduCreated(this.mDst, this.message.getNetworkLayerPdu().get(i));
            }
            if (this.mMeshStatusCallbacks != null) {
                this.mMeshStatusCallbacks.onMeshMessageProcessed(this.mDst, this.mMeshMessage);
            }
        }
    }

    final synchronized void executeResend(List<Integer> retransmitPduIndexes) {
        if (this.message.getNetworkLayerPdu().size() > 0 && !retransmitPduIndexes.isEmpty()) {
            for (int i = 0; i < retransmitPduIndexes.size(); ++i) {
                int segO = retransmitPduIndexes.get(i);
                if (this.message.getNetworkLayerPdu().get(segO) == null) continue;
                byte[] pdu = this.message.getNetworkLayerPdu().get(segO);
                LOG.info("Resending segment " + segO + " : " + MeshParserUtils.bytesToHex(pdu, false));
                Message retransmitMeshMessage = this.mMeshTransport.createRetransmitMeshMessage(this.message, segO);
                this.mInternalTransportCallbacks.onMeshPduCreated(this.mDst, retransmitMeshMessage.getNetworkLayerPdu().get(segO));
            }
        }
    }

    @Override
    public synchronized void onIncompleteTimerExpired() {
        LOG.info("Incomplete timer has expired, all segments were not received!");
        if (this.meshMessageHandlerCallbacks != null) {
            this.meshMessageHandlerCallbacks.onIncompleteTimerExpired(this.mDst);
            if (this.mMeshStatusCallbacks != null) {
                this.mMeshStatusCallbacks.onTransactionFailed(this.mDst, true);
            }
        }
    }

    @Override
    public synchronized int getTtl() {
        return this.message.getTtl();
    }

    @Override
    public synchronized void sendSegmentAcknowledgementMessage(ControlMessage controlMessage) {
        ControlMessage message = this.mMeshTransport.createSegmentBlockAcknowledgementMessage(controlMessage);
        LOG.info("Sending acknowledgement: " + MeshParserUtils.bytesToHex(message.getNetworkLayerPdu().get(0), false));
        this.mInternalTransportCallbacks.onMeshPduCreated(message.getDst(), message.getNetworkLayerPdu().get(0));
        this.mMeshStatusCallbacks.onBlockAcknowledgementProcessed(message.getDst(), controlMessage);
    }

    public static enum MessageState {
        PROXY_CONFIG_MESSAGE_STATE(500),
        CONFIG_MESSAGE_STATE(501),
        GENERIC_MESSAGE_STATE(502),
        VENDOR_MODEL_ACKNOWLEDGED_STATE(1000),
        VENDOR_MODEL_UNACKNOWLEDGED_STATE(1001);

        private int state;

        private MessageState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }
}

