/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.control.BlockAcknowledgementMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LowerTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.transport.UpperTransportLayer;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ExtendedInvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

abstract class LowerTransportLayer
extends UpperTransportLayer {
    public static final Logger LOG = Logger.getLogger(LowerTransportLayer.class.getName());
    private static final int BLOCK_ACK_TIMER = 150;
    private static final int UNSEGMENTED_HEADER = 0;
    private static final int SEGMENTED_HEADER = 1;
    private static final int UNSEGMENTED_MESSAGE_HEADER_LENGTH = 1;
    private static final int SEGMENTED_MESSAGE_HEADER_LENGTH = 4;
    private static final int UNSEGMENTED_ACK_MESSAGE_HEADER_LENGTH = 3;
    private static final long INCOMPLETE_TIMER_DELAY = 10000L;
    private final Map<Integer, byte[]> segmentedAccessMessageMap = new HashMap<Integer, byte[]>();
    private final Map<Integer, byte[]> segmentedControlMessageMap = new HashMap<Integer, byte[]>();
    LowerTransportLayerCallbacks mLowerTransportLayerCallbacks;
    private boolean mSegmentedAccessAcknowledgementTimerStarted;
    private Integer mSegmentedAccessBlockAck;
    private boolean mSegmentedControlAcknowledgementTimerStarted;
    private Integer mSegmentedControlBlockAck;
    private boolean mIncompleteTimerStarted;
    private boolean mBlockAckSent;
    private long mDuration;
    private Future<?> incompleteTimerTask = null;
    private final Runnable mIncompleteTimerRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LowerTransportLayer lowerTransportLayer = LowerTransportLayer.this;
            synchronized (lowerTransportLayer) {
                LowerTransportLayer.this.mLowerTransportLayerCallbacks.onIncompleteTimerExpired();
                LowerTransportLayer.this.mIncompleteTimerStarted = false;
            }
        }
    };

    LowerTransportLayer() {
    }

    protected abstract Future<?> startTask(Runnable var1, Long var2);

    protected abstract void stopTask(Future<?> var1);

    protected abstract void stopAllTasks();

    abstract void setLowerTransportLayerCallbacks(LowerTransportLayerCallbacks var1);

    protected abstract Message createNetworkLayerPDU(Message var1);

    @Override
    synchronized void createMeshMessage(Message message) {
        super.createMeshMessage(message);
        if (message instanceof AccessMessage) {
            this.createLowerTransportAccessPDU((AccessMessage)message);
        } else {
            this.createLowerTransportControlPDU((ControlMessage)message);
        }
    }

    @Override
    synchronized void createVendorMeshMessage(Message message) {
        if (message instanceof AccessMessage) {
            super.createVendorMeshMessage(message);
            this.createLowerTransportAccessPDU((AccessMessage)message);
        } else {
            this.createLowerTransportControlPDU((ControlMessage)message);
        }
    }

    @Override
    public final synchronized void createLowerTransportAccessPDU(AccessMessage message) {
        Map<Integer, byte[]> lowerTransportAccessPduMap;
        byte[] upperTransportPDU = message.getUpperTransportPdu();
        if (upperTransportPDU.length <= 12) {
            message.setSegmented(false);
            byte[] lowerTransportPDU = this.createUnsegmentedAccessMessage(message);
            lowerTransportAccessPduMap = new HashMap<Integer, byte[]>();
            lowerTransportAccessPduMap.put(0, lowerTransportPDU);
        } else {
            message.setSegmented(true);
            lowerTransportAccessPduMap = this.createSegmentedAccessMessage(message);
        }
        message.setLowerTransportAccessPdu(lowerTransportAccessPduMap);
    }

    @Override
    public final synchronized void createLowerTransportControlPDU(ControlMessage message) {
        switch (message.getPduType()) {
            case 2: {
                HashMap<Integer, byte[]> lowerTransportControlPduArray = new HashMap<Integer, byte[]>();
                lowerTransportControlPduArray.put(0, message.getTransportControlPdu());
                message.setLowerTransportControlPdu(lowerTransportControlPduArray);
                break;
            }
            case 0: {
                byte[] transportControlPdu = message.getTransportControlPdu();
                if (transportControlPdu.length <= 11) {
                    LOG.info("Creating unsegmented transport control");
                    this.createUnsegmentedControlMessage(message);
                    break;
                }
                LOG.info("Creating segmented transport control");
                this.createSegmentedControlMessage(message);
            }
        }
    }

    @Override
    final synchronized void reassembleLowerTransportAccessPDU(AccessMessage accessMessage) {
        Map<Integer, byte[]> lowerTransportAccessPdu = this.removeLowerTransportAccessMessageHeader(accessMessage);
        byte[] upperTransportPdu = MeshParserUtils.concatenateSegmentedMessages(lowerTransportAccessPdu);
        accessMessage.setUpperTransportPdu(upperTransportPdu);
    }

    @Override
    final synchronized void reassembleLowerTransportControlPDU(ControlMessage controlMessage) {
        Map<Integer, byte[]> lowerTransportPdu = this.removeLowerTransportControlMessageHeader(controlMessage);
        byte[] lowerTransportControlPdu = MeshParserUtils.concatenateSegmentedMessages(lowerTransportPdu);
        controlMessage.setTransportControlPdu(lowerTransportControlPdu);
    }

    private Map<Integer, byte[]> removeLowerTransportAccessMessageHeader(AccessMessage message) {
        Map<Integer, byte[]> messages = message.getLowerTransportAccessPdu();
        if (message.isSegmented()) {
            for (Integer index : messages.keySet()) {
                byte[] data = messages.get(index);
                int length = data.length - 4;
                messages.put(index, this.removeHeader(data, 4, length));
            }
        } else {
            Integer index = (Integer)messages.keySet().toArray()[0];
            byte[] data = messages.get(index);
            int length = data.length - 1;
            messages.put(index, this.removeHeader(data, 1, length));
        }
        return messages;
    }

    private Map<Integer, byte[]> removeLowerTransportControlMessageHeader(ControlMessage message) {
        Map<Integer, byte[]> messages = message.getLowerTransportControlPdu();
        if (messages.size() > 1) {
            for (Integer index : messages.keySet()) {
                byte[] data = messages.get(index);
                int length = data.length - 4;
                messages.put(index, this.removeHeader(data, 4, length));
            }
        } else {
            int opCode = message.getOpCode();
            if (opCode == 0) {
                Integer index = (Integer)messages.keySet().toArray()[0];
                byte[] data = messages.get(index);
                int length = data.length - 3;
                messages.put(index, this.removeHeader(data, 3, length));
            } else {
                Integer index = (Integer)messages.keySet().toArray()[0];
                byte[] data = messages.get(index);
                int length = data.length - 1;
                messages.put(index, this.removeHeader(data, 1, length));
            }
        }
        return messages;
    }

    private byte[] removeHeader(byte[] data, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.allocate(length).order(ByteOrder.BIG_ENDIAN);
        buffer.put(data, offset, length);
        return buffer.array();
    }

    private byte[] createUnsegmentedAccessMessage(AccessMessage message) {
        byte[] encryptedUpperTransportPDU = message.getUpperTransportPdu();
        int seg = message.isSegmented() ? 1 : 0;
        int akfAid = message.getAkf() << 6 | message.getAid();
        byte header = (byte)(seg << 7 | akfAid);
        ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(1 + encryptedUpperTransportPDU.length).order(ByteOrder.BIG_ENDIAN);
        lowerTransportBuffer.put(header);
        lowerTransportBuffer.put(encryptedUpperTransportPDU);
        byte[] lowerTransportPDU = lowerTransportBuffer.array();
        LOG.info("Unsegmented Lower transport access PDU " + MeshParserUtils.bytesToHex(lowerTransportPDU, false));
        return lowerTransportPDU;
    }

    private Map<Integer, byte[]> createSegmentedAccessMessage(AccessMessage message) {
        byte[] encryptedUpperTransportPDU = message.getUpperTransportPdu();
        int akfAid = message.getAkf() << 6 | message.getAid();
        int aszmic = message.getAszmic();
        byte[] sequenceNumber = message.getSequenceNumber();
        int seqZero = MeshParserUtils.calculateSeqZero(sequenceNumber);
        int numberOfSegments = (encryptedUpperTransportPDU.length + 11) / 12;
        int segN = numberOfSegments - 1;
        HashMap<Integer, byte[]> lowerTransportPduMap = new HashMap<Integer, byte[]>();
        int offset = 0;
        for (int segO = 0; segO < numberOfSegments; ++segO) {
            int length = Math.min(encryptedUpperTransportPDU.length - offset, 12);
            ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(4 + length).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put((byte)(0x80 | akfAid));
            lowerTransportBuffer.put((byte)(aszmic << 7 | seqZero >> 6 & 0x7F));
            lowerTransportBuffer.put((byte)(seqZero << 2 & 0xFC | segO >> 3 & 3));
            lowerTransportBuffer.put((byte)(segO << 5 & 0xE0 | segN & 0x1F));
            lowerTransportBuffer.put(encryptedUpperTransportPDU, offset, length);
            offset += length;
            byte[] lowerTransportPDU = lowerTransportBuffer.array();
            LOG.info("Segmented Lower transport access PDU: " + MeshParserUtils.bytesToHex(lowerTransportPDU, false) + " " + segO + " of " + numberOfSegments);
            lowerTransportPduMap.put(segO, lowerTransportPDU);
        }
        return lowerTransportPduMap;
    }

    private void createUnsegmentedControlMessage(ControlMessage message) {
        ByteBuffer lowerTransportBuffer;
        message.setSegmented(false);
        int opCode = message.getOpCode();
        byte[] parameters = message.getParameters();
        byte[] upperTransportControlPDU = message.getTransportControlPdu();
        byte header = (byte)(0 | opCode);
        if (parameters != null) {
            int pduLength = 1 + parameters.length + upperTransportControlPDU.length;
            lowerTransportBuffer = ByteBuffer.allocate(pduLength).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put(header);
            lowerTransportBuffer.put(parameters);
        } else {
            int pduLength = 1 + upperTransportControlPDU.length;
            lowerTransportBuffer = ByteBuffer.allocate(pduLength).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put(header);
        }
        lowerTransportBuffer.put(upperTransportControlPDU);
        byte[] lowerTransportPDU = lowerTransportBuffer.array();
        LOG.info("Unsegmented Lower transport control PDU " + MeshParserUtils.bytesToHex(lowerTransportPDU, false));
        HashMap<Integer, byte[]> lowerTransportControlPduMap = new HashMap<Integer, byte[]>();
        lowerTransportControlPduMap.put(0, lowerTransportPDU);
        message.setLowerTransportControlPdu(lowerTransportControlPduMap);
    }

    private void createSegmentedControlMessage(ControlMessage controlMessage) {
        controlMessage.setSegmented(false);
        byte[] encryptedUpperTransportControlPDU = controlMessage.getTransportControlPdu();
        int opCode = controlMessage.getOpCode();
        boolean rfu = false;
        byte[] sequenceNumber = controlMessage.getSequenceNumber();
        int seqZero = MeshParserUtils.calculateSeqZero(sequenceNumber);
        int numberOfSegments = (encryptedUpperTransportControlPDU.length + 7) / 8;
        int segN = numberOfSegments - 1;
        HashMap<Integer, byte[]> lowerTransportControlPduMap = new HashMap<Integer, byte[]>();
        int offset = 0;
        for (int segO = 0; segO < numberOfSegments; ++segO) {
            int length = Math.min(encryptedUpperTransportControlPDU.length - offset, 8);
            ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(4 + length).order(ByteOrder.BIG_ENDIAN);
            lowerTransportBuffer.put((byte)(0x80 | opCode));
            lowerTransportBuffer.put((byte)(0 | seqZero >> 6 & 0x7F));
            lowerTransportBuffer.put((byte)(seqZero << 2 & 0xFC | segO >> 3 & 3));
            lowerTransportBuffer.put((byte)(segO << 5 & 0xE0 | segN & 0x1F));
            lowerTransportBuffer.put(encryptedUpperTransportControlPDU, offset, length);
            offset += length;
            byte[] lowerTransportPDU = lowerTransportBuffer.array();
            LOG.info("Segmented Lower transport access PDU: " + MeshParserUtils.bytesToHex(lowerTransportPDU, false) + " " + segO + " of " + numberOfSegments);
            lowerTransportControlPduMap.put(segO, lowerTransportPDU);
        }
        controlMessage.setLowerTransportControlPdu(lowerTransportControlPduMap);
    }

    final boolean isSegmentedMessage(byte lowerTransportHeader) {
        return (lowerTransportHeader >> 7 & 1) == 1;
    }

    final synchronized AccessMessage parseUnsegmentedAccessLowerTransportPDU(byte[] pdu, int ivIndex, byte[] sequenceNumber) {
        AccessMessage message = null;
        byte header = pdu[10];
        int seg = header >> 7 & 1;
        int akf = header >> 6 & 1;
        int aid = header & 0x3F;
        if (seg == 0) {
            LOG.info("IV Index of received message: " + ivIndex);
            int seqAuth = ivIndex << 24 | MeshParserUtils.convert24BitsToInt(sequenceNumber);
            byte[] src = MeshParserUtils.getSrcAddress(pdu);
            int srcAdd = MeshParserUtils.unsignedBytesToInt(src[1], src[0]);
            LOG.info("SeqAuth: " + seqAuth);
            if (!this.isValidSeqAuth(seqAuth, srcAdd)) {
                return null;
            }
            this.mMeshNode.setSeqAuth(srcAdd, seqAuth);
            this.mMeshNode.setSequenceNumber(MeshParserUtils.convert24BitsToInt(sequenceNumber));
            message = new AccessMessage();
            if (akf == 0) {
                int lowerTransportPduLength = pdu.length - 10;
                ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(lowerTransportPduLength).order(ByteOrder.BIG_ENDIAN);
                lowerTransportBuffer.put(pdu, 10, lowerTransportPduLength);
                byte[] lowerTransportPDU = lowerTransportBuffer.array();
                HashMap<Integer, byte[]> messages = new HashMap<Integer, byte[]>();
                messages.put(0, lowerTransportPDU);
                message.setSegmented(false);
                message.setAszmic(0);
                message.setAkf(akf);
                message.setAid(aid);
                message.setLowerTransportAccessPdu(messages);
            } else {
                int lowerTransportPduLength = pdu.length - 10;
                ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(lowerTransportPduLength).order(ByteOrder.BIG_ENDIAN);
                lowerTransportBuffer.put(pdu, 10, lowerTransportPduLength);
                byte[] lowerTransportPDU = lowerTransportBuffer.array();
                HashMap<Integer, byte[]> messages = new HashMap<Integer, byte[]>();
                messages.put(0, lowerTransportPDU);
                message.setSegmented(false);
                message.setAszmic(0);
                message.setAkf(akf);
                message.setAid(aid);
                message.setLowerTransportAccessPdu(messages);
            }
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     */
    final synchronized AccessMessage parseSegmentedAccessLowerTransportPDU(int ttl, byte[] pdu, int ivIndex, byte[] sequenceNumber) {
        byte header = pdu[10];
        int akf = header >> 6 & 1;
        int aid = header & 0x3F;
        int szmic = pdu[11] >> 7 & 1;
        int seqZero = (pdu[11] & 0x7F) << 6 | (pdu[12] & 0xFC) >> 2;
        int segO = (pdu[12] & 3) << 3 | (pdu[13] & 0xE0) >> 5;
        int segN = pdu[13] & 0x1F;
        byte[] src = MeshParserUtils.getSrcAddress(pdu);
        byte[] dst = MeshParserUtils.getDstAddress(pdu);
        int blockAckSrc = MeshParserUtils.unsignedBytesToInt(dst[1], dst[0]);
        int blockAckDst = MeshParserUtils.unsignedBytesToInt(src[1], src[0]);
        LOG.info("SEG O: " + segO);
        LOG.info("SEG N: " + segN);
        int seqNumber = this.getTransportLayerSequenceNumber(MeshParserUtils.convert24BitsToInt(sequenceNumber), seqZero);
        int seqAuth = ivIndex << 24 | seqNumber;
        Integer lastSeqAuth = this.mMeshNode.getSeqAuth(blockAckDst);
        if (lastSeqAuth != null) {
            LOG.info("Last SeqAuth value " + lastSeqAuth);
        }
        LOG.info("Current SeqAuth value " + seqAuth);
        int payloadLength = pdu.length - 10;
        ByteBuffer payloadBuffer = ByteBuffer.allocate(payloadLength);
        payloadBuffer.put(pdu, 10, payloadLength);
        if (lastSeqAuth == null || lastSeqAuth < seqAuth) {
            this.mMeshNode.setSequenceNumber(seqNumber);
            this.segmentedAccessMessageMap.clear();
            this.segmentedAccessMessageMap.put(segO, payloadBuffer.array());
            this.mMeshNode.setSeqAuth(blockAckDst, seqAuth);
            LOG.info("Starting incomplete timer for src: " + MeshAddress.formatAddress(blockAckDst, false));
            this.initIncompleteTimer();
            if (!MeshAddress.isValidUnicastAddress(dst)) return null;
            this.mSegmentedAccessBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(null, segO);
            this.initSegmentedAccessAcknowledgementTimer(seqZero, ttl, blockAckSrc, blockAckDst, segN);
            return null;
        }
        if (lastSeqAuth != seqAuth) return null;
        if (!this.mIncompleteTimerStarted) {
            LOG.info("Ignoring message since the incomplete timer has expired and all messages have been received");
            return null;
        }
        if (this.segmentedAccessMessageMap.get(segO) == null) {
            this.segmentedAccessMessageMap.put(segO, payloadBuffer.array());
        }
        int receivedSegmentedMessageCount = this.segmentedAccessMessageMap.size();
        LOG.info("Received segment message count: " + receivedSegmentedMessageCount);
        if (receivedSegmentedMessageCount != segN + 1) {
            this.restartIncompleteTimer();
            LOG.info("Restarting incomplete timer for src: " + MeshAddress.formatAddress(blockAckDst, false));
            if (!MeshAddress.isValidUnicastAddress(dst)) return null;
            if (this.mSegmentedAccessAcknowledgementTimerStarted) return null;
            this.mSegmentedAccessBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(this.mSegmentedAccessBlockAck, segO);
            LOG.info("Restarting block acknowledgement timer for src: " + MeshAddress.formatAddress(blockAckDst, false));
            this.initSegmentedAccessAcknowledgementTimer(seqZero, ttl, blockAckSrc, blockAckDst, segN);
            return null;
        }
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.mSegmentedAccessBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(this.mSegmentedAccessBlockAck, segO);
            this.handleImmediateBlockAcks(seqZero, ttl, blockAckSrc, blockAckDst, segN);
        } else {
            this.cancelIncompleteTimer();
        }
        AccessMessage accessMessage = new AccessMessage();
        accessMessage.setAszmic(szmic);
        accessMessage.setSequenceNumber(MeshParserUtils.getSequenceNumberBytes(seqNumber));
        accessMessage.setAkf(akf);
        accessMessage.setAid(aid);
        accessMessage.setSegmented(true);
        HashMap<Integer, byte[]> segmentedMessages = new HashMap<Integer, byte[]>();
        Iterator<Integer> iterator = this.segmentedAccessMessageMap.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                accessMessage.setLowerTransportAccessPdu(segmentedMessages);
                return accessMessage;
            }
            Integer index = iterator.next();
            segmentedMessages.put(index, (byte[])this.segmentedAccessMessageMap.get(index).clone());
        }
    }

    private void handleImmediateBlockAcks(int seqZero, int ttl, int src, int dst, int segN) {
        this.cancelIncompleteTimer();
        this.sendBlockAck(seqZero, ttl, src, dst, segN);
    }

    final synchronized void parseUnsegmentedControlLowerTransportPDU(ControlMessage controlMessage, byte[] decryptedProxyPdu) throws ExtendedInvalidCipherTextException {
        HashMap<Integer, byte[]> unsegmentedMessages = new HashMap<Integer, byte[]>();
        int lowerTransportPduLength = decryptedProxyPdu.length - 10;
        ByteBuffer lowerTransportBuffer = ByteBuffer.allocate(lowerTransportPduLength).order(ByteOrder.BIG_ENDIAN);
        lowerTransportBuffer.put(decryptedProxyPdu, 10, lowerTransportPduLength);
        byte[] lowerTransportPDU = lowerTransportBuffer.array();
        unsegmentedMessages.put(0, lowerTransportPDU);
        byte pduType = decryptedProxyPdu[0];
        switch (pduType) {
            case 0: {
                byte header = decryptedProxyPdu[10];
                int opCode = header & 0x7F;
                controlMessage.setPduType(0);
                controlMessage.setAszmic(0);
                controlMessage.setOpCode(opCode);
                controlMessage.setLowerTransportControlPdu(unsegmentedMessages);
                this.parseLowerTransportLayerPDU(controlMessage);
                break;
            }
            case 2: {
                controlMessage.setPduType(2);
                controlMessage.setLowerTransportControlPdu(unsegmentedMessages);
                this.parseUpperTransportPDU(controlMessage);
            }
        }
    }

    final synchronized ControlMessage parseSegmentedControlLowerTransportPDU(byte[] pdu) {
        byte header = pdu[10];
        int akf = header >> 6 & 1;
        int aid = header & 0x3F;
        int szmic = pdu[11] >> 7 & 1;
        int seqZero = (pdu[11] & 0x7F) << 6 | (pdu[12] & 0xFC) >> 2;
        int segO = (pdu[12] & 3) << 3 | (pdu[13] & 0xE0) >> 5;
        int segN = pdu[13] & 0x1F;
        int ttl = pdu[2] & 0x7F;
        byte[] src = MeshParserUtils.getSrcAddress(pdu);
        byte[] dst = MeshParserUtils.getDstAddress(pdu);
        int blockAckSrc = MeshParserUtils.unsignedBytesToInt(dst[1], dst[0]);
        int blockAckDst = MeshParserUtils.unsignedBytesToInt(src[1], src[0]);
        LOG.info("SEG O: " + segO);
        LOG.info("SEG N: " + segN);
        this.initSegmentedControlAcknowledgementTimer(seqZero, ttl, blockAckDst, blockAckSrc, segN);
        this.mSegmentedControlBlockAck = BlockAcknowledgementMessage.calculateBlockAcknowledgement(this.mSegmentedControlBlockAck, segO);
        LOG.info("Block acknowledgement value for " + this.mSegmentedControlBlockAck + " Seg O " + segO);
        int payloadLength = pdu.length - 10;
        ByteBuffer payloadBuffer = ByteBuffer.allocate(payloadLength);
        payloadBuffer.put(pdu, 10, payloadLength);
        this.segmentedControlMessageMap.put(segO, payloadBuffer.array());
        int receivedSegmentedMessageCount = this.segmentedControlMessageMap.size() - 1;
        if (segN == receivedSegmentedMessageCount) {
            LOG.info("All segments received");
            this.stopTask(this.incompleteTimerTask);
            this.incompleteTimerTask = null;
            LOG.info("Block ack sent? " + this.mBlockAckSent);
            if (this.mDuration > System.currentTimeMillis() && !this.mBlockAckSent && MeshAddress.isValidUnicastAddress(dst)) {
                this.stopAllTasks();
                this.incompleteTimerTask = null;
                LOG.info("Cancelling Scheduled block ack and incomplete timer, sending an immediate block ack");
                this.sendBlockAck(seqZero, ttl, blockAckSrc, blockAckDst, segN);
            }
            int upperTransportSequenceNumber = this.getTransportLayerSequenceNumber(MeshParserUtils.getSequenceNumberFromPDU(pdu), seqZero);
            byte[] sequenceNumber = MeshParserUtils.getSequenceNumberBytes(upperTransportSequenceNumber);
            ControlMessage message = new ControlMessage();
            message.setAszmic(szmic);
            message.setSequenceNumber(sequenceNumber);
            message.setAkf(akf);
            message.setAid(aid);
            message.setSegmented(true);
            HashMap<Integer, byte[]> segmentedMessages = new HashMap<Integer, byte[]>();
            for (Integer index : this.segmentedControlMessageMap.keySet()) {
                segmentedMessages.put(index, (byte[])this.segmentedControlMessageMap.get(index).clone());
            }
            this.segmentedControlMessageMap.clear();
            message.setLowerTransportControlPdu(segmentedMessages);
            return message;
        }
        return null;
    }

    private void initIncompleteTimer() {
        this.incompleteTimerTask = this.startTask(this.mIncompleteTimerRunnable, 10000L);
        this.mIncompleteTimerStarted = true;
    }

    private void restartIncompleteTimer() {
        if (this.mIncompleteTimerStarted) {
            this.stopTask(this.incompleteTimerTask);
            this.incompleteTimerTask = null;
        }
        this.initIncompleteTimer();
    }

    private void cancelIncompleteTimer() {
        this.mIncompleteTimerStarted = false;
        this.stopTask(this.incompleteTimerTask);
        this.incompleteTimerTask = null;
    }

    private void initSegmentedAccessAcknowledgementTimer(int seqZero, int ttl, int src, int dst, int segN) {
        if (!this.mSegmentedAccessAcknowledgementTimerStarted) {
            this.mSegmentedAccessAcknowledgementTimerStarted = true;
            LOG.info("TTL: " + ttl);
            int duration = 150 + 50 * ttl;
            LOG.info("Duration: " + duration);
            this.mDuration = System.currentTimeMillis() + (long)duration;
            this.startTask(() -> {
                LowerTransportLayer lowerTransportLayer = this;
                synchronized (lowerTransportLayer) {
                    LOG.info("Acknowledgement timer expiring");
                    this.sendBlockAck(seqZero, ttl, src, dst, segN);
                }
            }, Integer.valueOf(duration).longValue());
        }
    }

    private void initSegmentedControlAcknowledgementTimer(int seqZero, int ttl, int src, int dst, int segN) {
        if (!this.mSegmentedControlAcknowledgementTimerStarted) {
            this.mSegmentedControlAcknowledgementTimerStarted = true;
            int duration = 150 + 50 * ttl;
            this.mDuration = System.currentTimeMillis() + (long)duration;
            this.startTask(() -> {
                LowerTransportLayer lowerTransportLayer = this;
                synchronized (lowerTransportLayer) {
                    this.sendBlockAck(seqZero, ttl, src, dst, segN);
                }
            }, Integer.valueOf(duration).longValue());
        }
    }

    private void sendBlockAck(int seqZero, int ttl, int src, int dst, int segN) {
        int blockAck = this.mSegmentedAccessBlockAck;
        if (BlockAcknowledgementMessage.hasAllSegmentsBeenReceived(blockAck, segN)) {
            LOG.info("All segments received cancelling incomplete timer");
            this.cancelIncompleteTimer();
        }
        byte[] upperTransportControlPdu = this.createAcknowledgementPayload(seqZero, blockAck);
        LOG.info("Block acknowledgement payload: " + MeshParserUtils.bytesToHex(upperTransportControlPdu, false));
        ControlMessage controlMessage = new ControlMessage();
        controlMessage.setOpCode(0);
        controlMessage.setTransportControlPdu(upperTransportControlPdu);
        controlMessage.setTtl(ttl);
        controlMessage.setPduType(0);
        controlMessage.setSrc(src);
        controlMessage.setDst(dst);
        controlMessage.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        int sequenceNumber = this.mUpperTransportLayerCallbacks.getNode(controlMessage.getSrc()).incrementSequenceNumber();
        byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(sequenceNumber);
        controlMessage.setSequenceNumber(sequenceNum);
        this.mBlockAckSent = true;
        this.mLowerTransportLayerCallbacks.sendSegmentAcknowledgementMessage(controlMessage);
        this.mSegmentedAccessAcknowledgementTimerStarted = false;
    }

    private byte[] createAcknowledgementPayload(int seqZero, int blockAcknowledgement) {
        boolean obo = false;
        boolean rfu = false;
        ByteBuffer buffer = ByteBuffer.allocate(6).order(ByteOrder.BIG_ENDIAN);
        buffer.put((byte)(0 | seqZero >> 6 & 0x7F));
        buffer.put((byte)(seqZero << 2 & 0xFC | 0));
        buffer.putInt(blockAcknowledgement);
        return buffer.array();
    }

    private void parseLowerTransportLayerPDU(ControlMessage controlMessage) {
        this.reassembleLowerTransportControlPDU(controlMessage);
        byte[] transportControlPdu = controlMessage.getTransportControlPdu();
        int opCode = controlMessage.getOpCode();
        if (opCode == 0) {
            BlockAcknowledgementMessage acknowledgement = new BlockAcknowledgementMessage(transportControlPdu);
            controlMessage.setTransportControlMessage(acknowledgement);
        }
    }

    private boolean isValidSeqAuth(int seqAuth, int src) {
        Integer lastSeqAuth = this.mMeshNode.getSeqAuth(src);
        return lastSeqAuth == null || lastSeqAuth < seqAuth;
    }
}

