/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class LightLightnessStatus
extends GenericStatusMessage {
    public static final Logger LOG = Logger.getLogger(LightLightnessStatus.class.getName());
    private static final int LIGHT_LIGHTNESS_STATUS_MANDATORY_LENGTH = 2;
    private static final int OP_CODE = 33358;
    private int mPresentLightness;
    private Integer mTargetLightness;
    private int mTransitionSteps;
    private int mTransitionResolution;

    public LightLightnessStatus(AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received light lightness status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentLightness = buffer.getShort() & 0xFFFF;
        LOG.info("Present level: " + this.mPresentLightness);
        if (buffer.limit() > 2) {
            this.mTargetLightness = buffer.getShort() & 0xFFFF;
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            LOG.info("Target level: " + this.mTargetLightness);
            LOG.info("Remaining time, transition number of steps: " + this.mTransitionSteps);
            LOG.info("Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            LOG.info("Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33358;
    }

    public final int getPresentLightness() {
        return this.mPresentLightness;
    }

    public final Integer getTargetLightness() {
        return this.mTargetLightness;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }
}

